/* voir http://developer.gnome.org/doc/API/2.0/gtk/GtkRadioButton.html                */
/* voir http://www.gtk-fr.org/wakka.php?wiki=PageAccueil                              */
/* voir http://zaide.script-kiddy.fr/documentation/programmation/Cours-Gtk2           */
/* http://computing.ee.ethz.ch/sepp/gtk-2.0.6-mo/gtkimage.html#gtk-image-get-icon-set */
/* http://fr.wikibooks.org/wiki/Programmation_GTK_plus_Pixmaps                        */
/* http://developer.gnome.org/arch/imaging/gdkpixbuf.html                             */
/* http://fr.wikipedia.org/wiki/Taquin                                                */
/* http://www.linux-france.org/article/devl/gtk/gtk_tut.html                          */
/* http://developer.gnome.org/doc/API/2.0/gdk-pixbuf/index.html                       */

#include<stdlib.h>
#include<gtk/gtk.h>
#include<string.h>
#include<time.h>

/*#define dim_x 3
#define dim_y 3*/
#define TAILLE 600

typedef struct
{
 unsigned char x;
 unsigned char y;
} x_y;

void cb_fin(GtkWidget *,gpointer);
gboolean callback_label(GtkWidget *, GdkEventButton *, x_y *);
int melange();
static void menu_addWidget (GtkUIManager *, GtkWidget *, GtkContainer *);
void melange_aff(GtkWidget *, gpointer);
void decoupe(GtkWidget *,gpointer);
void nouvelle_image(GtkWidget *,gpointer);
void menu_aide(GtkWidget *,gpointer);
void menu_a_propos(GtkWidget *,gpointer);
void menu_licence(GtkWidget *,gpointer);
void taille();
void morceaux();
void signal_morceaux();
void choix_fichier();
void traite_erreur(GError *);

GdkColormap * negative(GdkColormap *);

unsigned short dim_x=0,dim_y=0,taille_x,taille_y;

GtkWidget *** image=NULL;
GdkPixbuf *** pourdessin;
GtkWidget *** case_table=NULL;
GtkWidget *table=NULL;
x_y ** case_click;
GdkPixbuf * petite=NULL;
GtkWidget * petite_image=NULL;
GtkWidget *p_main_box = NULL;    /* le conteneur principal */
GtkWidget *p_window = NULL;      /* la fenêtre             */

GtkWidget * mes_horizontal=NULL;

unsigned short **pous;
GdkPixbuf * dessin=NULL;

char * fichier=NULL;

int placepous(unsigned short,unsigned short);

int main (int argc, char **argv)
{
 GtkWidget * horizontal=NULL;
 GtkWidget * ligneh;
 GtkAccelGroup *accel_group;                                        /* Pour les raccourcis claviers                                 */
 GError * error;
 
 /* menu */
 GtkUIManager *menu_Manager;
 GtkActionEntry entrees_menu[] = 
 {
  {"FichierMenuAction",NULL           ,"Jeu"              , NULL       , NULL                            , NULL                        },
  {"Melange"	      ,GTK_STOCK_NEW  ,"Melange"          ,"<Control>M","Melange les cases du pouspous"  , G_CALLBACK( melange_aff    )},
  {"NouveauDecoupage" ,GTK_STOCK_OPEN ,"Nouveau decoupage","<Control>D","Change le decoupage du pouspous", G_CALLBACK( decoupe        )},
  {"NouvelleImage"    ,GTK_STOCK_FILE ,"Nouvelle Image"   ,"<Control>I","Change l'image du pouspous"     , G_CALLBACK( nouvelle_image )},
  {"Quitter"          ,GTK_STOCK_QUIT ,"Quitter"          ,"<Control>Q","Finir la partie"                , G_CALLBACK( cb_fin         )},
  {"AideMenuAction"   ,NULL           ,"Aide"             , NULL       , NULL                            , NULL                        },
  {"Aide"             ,GTK_STOCK_HELP ,"Aide"             ,"<Shift>A"  , NULL                            , G_CALLBACK( menu_aide      )},
  {"AproposAction"    ,GTK_STOCK_ABOUT,"A propos"         ,"<Alt>A"    , NULL                            , G_CALLBACK( menu_a_propos  )},
  {"Licence"          ,GTK_STOCK_INFO ,"Licence GPL"      ,"<Release>L", NULL                            , G_CALLBACK( menu_licence   )}
 };
 GtkActionGroup * p_actionGroup;
 
 /* Initialisation de GTK+ */
 gtk_init (&argc, &argv);
 p_window = gtk_window_new(GTK_WINDOW_TOPLEVEL); 

 /* initialisation de l'icone */
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (p_window),"pouspous.ico",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 p_main_box=gtk_vbox_new(FALSE,0);
 gtk_container_add (GTK_CONTAINER (p_window), p_main_box);

 /* initialisation du menu */
 menu_Manager = gtk_ui_manager_new ();
 gtk_ui_manager_add_ui_from_file(menu_Manager,"main.menu.xml",NULL);
 g_signal_connect(menu_Manager,"add_widget",G_CALLBACK( menu_addWidget ),GTK_CONTAINER(p_main_box));
 p_actionGroup = gtk_action_group_new( "menuActionGroup" );
 gtk_action_group_add_actions( p_actionGroup, entrees_menu, G_N_ELEMENTS( entrees_menu ), NULL );
 gtk_ui_manager_insert_action_group( menu_Manager, p_actionGroup, 0 );
 /******************************************************/
 /*  manipulation pour activer les raccourcis clavier  */
 accel_group = gtk_ui_manager_get_accel_group (menu_Manager);       /* Création de l'AccelGroup à partir du GtkActionEntry          */
 gtk_window_add_accel_group (GTK_WINDOW (p_window), accel_group);   /* Activation des raccourcis clavier à partir de l'AccelGroup   */
 /******************************************************/

 /* déclaration du nom de la fenêtre */
 gtk_window_set_title (GTK_WINDOW (p_window),"PousPous");

 horizontal=gtk_hbox_new(TRUE,0);
 mes_horizontal=gtk_label_new("");
 gtk_box_pack_start(GTK_BOX(horizontal),mes_horizontal,FALSE,FALSE,0);
 ligneh=gtk_hseparator_new();

 
if (argc >1) /* la fonction a t'ele été appelé avec des arguments ? */
 {
  if (sscanf(argv[1],"%hu",&dim_x)!=1) /* le premier argument n'est pas un nombre */
  {
   printf("%s [x [y [image]]\nx est le nombre de cases horizontales, y verticales ((si x est omi y=x\nimage est le chemin vers l'image à découper(./20041203_laMouette-Vole.png par défaut)",argv[0]);
   return 0;
  }
  if (argc==2) /* premier argument : le nom de la fonction, second : x et rien d'autre */
   dim_y=dim_x;
  else
   sscanf(argv[2],"%hu",&dim_y);
 }
 else
  taille();
 
 if (argc>3)
  fichier=argv[3];
 else
  choix_fichier();

 gtk_box_pack_start(GTK_BOX(p_main_box),horizontal,FALSE,FALSE,0);
 gtk_box_pack_start(GTK_BOX(p_main_box),ligneh,FALSE,FALSE,0);
 melange();

 morceaux();
 signal_morceaux(); /* génère table en même temps */

 /* génération et affichage de petite image */
 petite_image=gtk_image_new_from_pixbuf(petite);
 gtk_box_pack_start(GTK_BOX(horizontal),petite_image,FALSE,FALSE,0); 

 /* connexion du bouton fermeture de la fenêtre sur la destruction de l'image */
 g_signal_connect (G_OBJECT (p_window), "destroy", G_CALLBACK (cb_fin),NULL);

 gtk_widget_show_all (p_window);
 gtk_main ();

 return 1;
}

void cb_fin(GtkWidget *p_widget, gpointer param)
{
  gtk_main_quit();
  
 /* parametres inutilises */
 (void)p_widget;
 (void)param;
}

unsigned short affiche()
{
 unsigned short i,j,k=0;
 
 for (i=0;i<dim_x;i++)
 {
  for(j=0;j<dim_y;j++)
  {
   /* http://developer.gnome.org/doc/API/2.0/gtk/GtkImage.html#gtk-image-set-from-pixbuf */
   gtk_image_set_from_pixbuf(GTK_IMAGE(image[i][j]),pourdessin[pous[i][j]/dim_y][pous[i][j]%dim_y]);
   /* décompte du nombre de case mal placées */
   if ((pous[i][j]/dim_y)!=i || (pous[i][j]%dim_y)!=j) k++;
  }
  /*printf("\n");*/
 }
 gtk_widget_show_all(p_window);
 
 return k;
}

gboolean callback_label(GtkWidget *widget, GdkEventButton *event, x_y * user_data)
{
 unsigned short retour=1;
 GtkWidget * diag;
 GtkWidget * mes;
 char ch[32];
 GError * error;
 
/*printf("Le lien %hu %hu a été cliqué\n",user_data->x,user_data->y);*/
	
 if (placepous(user_data->x,user_data->y)) /* s'il y a eu un mouvement */
 {
  retour=affiche();
  /* affichage du nombre de cases mal placées */
  sprintf(ch,"%hu case%c mal placée%c\n",retour,retour<2?' ':'s',retour<2?' ':'s');
  gtk_label_set_text(GTK_LABEL(mes_horizontal),ch);

  if (retour==0)
  {
   /* préparation d'un boite de dialogue pour savoir si on refait une partie */
   diag=gtk_dialog_new_with_buttons("Gagné !",NULL,GTK_DIALOG_MODAL,GTK_STOCK_YES,GTK_RESPONSE_OK,GTK_STOCK_NO,GTK_RESPONSE_NO,NULL);
   if (!gtk_window_set_icon_from_file(GTK_WINDOW (diag),"pouspous.ico",&error))
   {                                                                  /* met une icone à la fenêtre                                   */
    traite_erreur(error);
    free(error);
   }
   mes=gtk_label_new("Vous avez gagné !\nUne autre partie ?");
   gtk_box_pack_start(GTK_BOX(GTK_DIALOG(diag)->vbox), mes, TRUE, FALSE, 0);
   /* affichage de la boite de dialogue */
   gtk_widget_show_all(GTK_DIALOG(diag)->vbox);
   switch (gtk_dialog_run(GTK_DIALOG(diag)))
   {
     case GTK_RESPONSE_OK:
      melange();
      affiche();
      break;
     default :
      cb_fin(widget,NULL);
   }
   gtk_widget_destroy(diag);
  }
 }
 /* renvoie 1 si retour est nul, 0 sinon */
 return retour==0;
 
 (void)event;
}

int placepous(unsigned short x,unsigned short y)
{
 unsigned short i;
 
/*unsigned short j;
for (j=0;j<dim_y;j++){ for (i=0;i<dim_x;i++)  printf("pous[%hu][%hu]=%hu ;",i,j,pous[i][j]); printf("\n");}*/
 
 /* si on veut mettre le trou où il est déjà on sort */
 if (pous[x][y]==0) return 0; 
 /* recherche du trou dans la colonne de x,y */
 for(i=0;i<dim_y;i++)
 {
  if (pous[x][i]==0) /* on a trouvé le trou */
  {
   if (i!=y) /* ne devrait pas arriver */
   {
    if (i<y)
    {
     for(;i<y;i++) /* déplacement du trou */
      pous[x][i]=pous[x][i+1];
     /*pous[x][y]=0;*/
    }
    else /* i>y */
    {
     for(;i>y;i--)
      pous[x][i]=pous[x][i-1];
     /*pous[x][y]=0;*/
    }
    pous[x][y]=0;
   }
   i=dim_y; /* force la sortie de la bouocle */
  }
 }
 
 /* si le trou a été placé sur x,y on sort */
 if (pous[x][y]==0) return 1;
 /* recherche du trou dans la ligne de x,y */
 for(i=0;i<dim_x;i++)
 {
  if (pous[i][y]==0)
  {
   if (i!=x)
   {
    if(i<x)
    {
     for(;i<x;i++)
      pous[i][y]=pous[i+1][y];
     pous[x][y]=0;
    }
    else /*i>x*/
    {
     for(;i>x;i--)
      pous[i][y]=pous[i-1][y];
     pous[x][y]=0;
    }
   }
   i=dim_x;
  }
 }
 
 return (pous[x][y]==0);
}

int melange()
{
 unsigned short i,j,n;

 srand((unsigned int)time(0));
 n=dim_x*dim_y*50;
 do
 {
  i=rand()%dim_x;
  j=rand()%dim_y;
  n-=placepous(i,j);
 }
 while (n>0); /* melange */
 /* tant qu'il n'y a pas dim_x*dim_y*50 mouvements */
 return n;
}

static void menu_addWidget (GtkUIManager * p_uiManager, GtkWidget * p_widget, GtkContainer * p_box)
{
   gtk_box_pack_start (GTK_BOX (p_box), p_widget, FALSE, FALSE, 0);
   gtk_widget_show (p_widget);
   return;
   
   (void)p_uiManager;
}

void decoupe(GtkWidget *p_widget, gpointer param)
{
 taille();
 melange();
 morceaux();
 signal_morceaux();
 affiche();
 
 (void)p_widget;
 (void)param;
}

void nouvelle_image(GtkWidget *p_widget, gpointer param)
{
 choix_fichier();
 morceaux();
 affiche();
 gtk_image_set_from_pixbuf(GTK_IMAGE(petite_image),petite);
 
 (void)p_widget;
 (void)param;
}

void menu_aide(GtkWidget *p_widget, gpointer param)
{
 GtkWidget *dialogue = NULL;
 GtkWidget *d_label1 = NULL;
 GtkWidget *petite_image = NULL;
 GtkWidget *d_label2 = NULL;
 GtkWidget *im0 = NULL;
 GtkWidget *d_label3 = NULL;
 GError * error;
 
  
 dialogue=gtk_dialog_new();
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"pouspous.ico",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 gtk_window_set_title(GTK_WINDOW(dialogue),"Aide");
 gtk_window_set_default_size(GTK_WINDOW(dialogue),300,-1);
 /* création d'un label (espace de texte) avec un texte simple, sans formatage */
 d_label1=gtk_label_new("Vous devez reconstituer l'image suivante :");
 gtk_label_set_line_wrap(GTK_LABEL(d_label1),FALSE);
 /* insertion du label dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label1, TRUE, TRUE, 0);
 
 petite_image=gtk_image_new_from_pixbuf(petite);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), petite_image, TRUE, TRUE, 0);

 d_label2=gtk_label_new("En faisant glisser les lignes ou les colonnes\nde la case sur laquelle vous cliquez\nvers le trou symbolisé par l'image :");
 gtk_label_set_line_wrap(GTK_LABEL(d_label2),FALSE);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label2, TRUE, TRUE, 0);
 
 im0=gtk_image_new_from_pixbuf(pourdessin[0][0]);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), im0, TRUE, TRUE, 0);

 d_label3=gtk_label_new("Au départ, vous choisissez\n le nombre de colonnes et de lignes du découpage\n ainsi que l'image à découper\n ( 20041203_laMouette-Vole.png par défaut)\n\nLors de la partie,\nvous pouvez à tout moment changer ces paramètres\n grâce au menu jeu.");
 gtk_label_set_line_wrap(GTK_LABEL(d_label3),FALSE);
 /* insertion du label dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX(GTK_DIALOG(dialogue)->vbox), d_label3, TRUE, TRUE, 0);

 
 gtk_label_set_justify(GTK_LABEL(d_label1),GTK_JUSTIFY_CENTER);
 gtk_label_set_justify(GTK_LABEL(d_label2),GTK_JUSTIFY_CENTER);
 gtk_label_set_justify(GTK_LABEL(d_label3),GTK_JUSTIFY_CENTER);
 
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 /* On lance la boite de dialogue */
 gtk_dialog_run(GTK_DIALOG(dialogue));
 
 (void)p_widget;
 (void)param;
}

void menu_a_propos(GtkWidget *p_widget, gpointer param)
{
 GtkWidget *dialogue = NULL;
 GtkWidget *d_label = NULL;
 GError * error;
  
 dialogue=gtk_dialog_new();
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"pouspous.ico",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 gtk_window_set_title(GTK_WINDOW(dialogue),"A Propos");
 gtk_window_set_default_size(GTK_WINDOW(dialogue),300,-1);
 /* création d'un label (espace de texte) avec un texte simple, sans formatage */
 d_label=gtk_label_new("Pouspous Taquin\npar\nTroumad Alias Bernard SIAUD\nhttp://troumad.org\n\nRemerciements à\nhttp://gtk.developpez.com");
 
 gtk_label_set_line_wrap(GTK_LABEL(d_label),FALSE);
 /* insertion du label dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label, TRUE,TRUE, 0);
 gtk_label_set_justify(GTK_LABEL(d_label),GTK_JUSTIFY_CENTER);
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 /* On lance la boite de dialogue */
 gtk_dialog_run(GTK_DIALOG(dialogue));
 
 (void)p_widget;
 (void)param; 
}

void menu_licence(GtkWidget *p_widget, gpointer param)
{
 GtkWidget *dialogue = NULL;
 GtkWidget *d_label = NULL;
 GtkWidget *d_label1 = NULL;
 GError * error;

 dialogue=gtk_dialog_new();
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"gnu-head-mini.png",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 gtk_window_set_title(GTK_WINDOW(dialogue),"Licence GPL");
 gtk_window_set_default_size(GTK_WINDOW(dialogue),300,-1);
 /* création d'un label (espace de texte) avec un texte simple, sans formatage */
 d_label=gtk_label_new("Copyright (c) 2007 Bernard SIAUD.\n\nPermission is granted to copy, distribute and/or modify this document under the terms of the GNU Free Documentation License, Version 1.2 or any later version published by the Free Software Foundation; with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts. A copy of the license is included in the section entitled  \"GNU Free Documentation License\" :  http://www.gnu.org/licenses/fdl.txt");
 d_label1=gtk_label_new("\n\nVersion française non officielle : http://fsffrance.org/gpl/gpl.fr.html");
 /* label avec saut de ligne */
 gtk_label_set_line_wrap(GTK_LABEL(d_label),TRUE);
 gtk_label_set_line_wrap(GTK_LABEL(d_label1),TRUE);
 /* insertion du label dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label, TRUE, TRUE, 0);
 gtk_label_set_justify(GTK_LABEL(d_label),GTK_JUSTIFY_CENTER);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label1, TRUE, TRUE, 0);
 gtk_label_set_justify(GTK_LABEL(d_label1),GTK_JUSTIFY_CENTER);
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 /* On lance la boite de dialogue */
 gtk_dialog_run(GTK_DIALOG(dialogue));

 (void)p_widget;
 (void)param;
}

void melange_aff(GtkWidget *p_widget, gpointer param)
{
 melange();
 affiche();
 
 (void)p_widget;
 (void)param;
}

void taille()
{
 /* boite de dialogue */
 GtkWidget *dialogue = NULL;
 GtkWidget *d_label = NULL;
 GtkWidget *lar = NULL;
 GtkWidget *xl = NULL;
 GtkWidget *fois = NULL;
 GtkWidget *yh = NULL;
 GError * error;
 unsigned i,j;
 char ch[32];
 
 gtk_widget_hide_all(p_window);
 if (case_table) /* premier passage */
 {
  /*gtk_widget_hide_all(GTK_WIDGET(table));*/
  for(i=0;i<dim_x;i++)
  {
   /*if (dim_x!=0)*/
    for (j=0;j<dim_y;j++)
    {
     /*gtk_container_remove(GTK_CONTAINER(case_table[i][j]),GTK_WIDGET(image[i][j]));*/
     gdk_pixbuf_unref( pourdessin[i][j]);
     gtk_object_destroy(GTK_OBJECT(image[i][j])); 
     gtk_object_destroy(GTK_OBJECT(case_table[i][j]));
     /*gtk_object_destroy(GTK_OBJECT(pourdessin[i][j]));*/
/*GdkPixbuf *** pourdessin;*/
    }
   free(case_table[i]);
   free(case_click[i]);
   free(image[i]);
   free(pous[i]);
   free(pourdessin[i]);
  }
  free(case_table);
  free(case_click);
  free(image);
  free(pous);
  free(pourdessin);
  gtk_object_destroy(GTK_OBJECT(table));
 }

 dim_y=3;
 dim_x=3;
 dialogue=gtk_dialog_new_with_buttons("Dimension du pouspous taquin",NULL, GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_OK,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"pouspous.ico",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 /* création d'un label (espace de texte) avec un texte simple, sans formatage */
 d_label=gtk_label_new("Nombre de cases :  largeur x hauteur");
 /* insertion du label dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),d_label, TRUE, TRUE, 0);
 /* création d'un conteneur horizontal : lar */
 lar = gtk_hbox_new (FALSE, 0);
 /* insertion du conteneur lar dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),  GTK_WIDGET (lar), TRUE, TRUE, 0);
 /* création de la première boite de dialogue : pour le paramètre x */
 xl=gtk_entry_new();
 gtk_entry_set_text(GTK_ENTRY(xl),"3");
 /* gtk_widget_set_usize à tester */
 /* facultatif : nombre maximum de caractères qu'on peut entrer dans la boite de dialogue */
 gtk_entry_set_max_length(GTK_ENTRY(xl),2);
 /* insertion de cette boite dans lar */
 gtk_box_pack_start (GTK_BOX (lar),  GTK_WIDGET (xl), FALSE, FALSE, 0);
 /* création d'un label x pour symboliser le signe multiplier */
 fois=gtk_label_new("x");
 /* insertion du signe x après la première boite de dialogue */
 gtk_box_pack_start (GTK_BOX (lar),  GTK_WIDGET (fois), TRUE, TRUE, 0);
 /* boite de dialogue pour le paramètre y : mêm topo que pour x */
 yh=gtk_entry_new();
 gtk_entry_set_text(GTK_ENTRY(yh),"3");
 gtk_entry_set_max_length(GTK_ENTRY(yh),2);
 gtk_box_pack_start (GTK_BOX (lar), GTK_WIDGET (yh), FALSE,FALSE, 0);
 
 /* obligatoire pour afficher le contenu de la boite de dialogue */
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 /* On lance la boite de dialogue */
 switch (gtk_dialog_run(GTK_DIALOG(dialogue)))
 {
  case GTK_RESPONSE_NONE:
      printf("case GTK_RESPONSE_NONE:\n");
  case GTK_RESPONSE_CANCEL:
      gtk_widget_destroy(dialogue);
      break;
  case GTK_RESPONSE_OK:
      /* on récupère les nombres rentrés dans ces boites de dialogue */
      dim_x = atof(gtk_entry_get_text(GTK_ENTRY(xl)));
      dim_y = atof(gtk_entry_get_text(GTK_ENTRY(yh)));
      gtk_widget_destroy(dialogue);
      break; /* inutile normalement */
  default :
      gtk_widget_destroy(dialogue);
      printf("default:\n"); /* normalement, on ne passe pas par là */
 }
 /*if (table)
 {
  gtk_table_resize(GTK_TABLE(table),dim_x,dim_y);
 }
 else*/
 {
  table=gtk_table_new(dim_x,dim_y,FALSE);
  gtk_table_set_row_spacings(GTK_TABLE (table),2);
  gtk_table_set_col_spacings(GTK_TABLE (table),2);
  gtk_box_pack_start(GTK_BOX(p_main_box),table,FALSE,FALSE,0);
 }
 
 sprintf(ch,"Nombre de cases :  %hu x %hu",dim_x,dim_y);
 gtk_label_set_text(GTK_LABEL(mes_horizontal),ch);
 
 pourdessin=(GdkPixbuf ***)malloc(dim_x*sizeof(GdkPixbuf **));
 case_table=(GtkWidget ***)malloc(dim_x*sizeof(GtkWidget **));
 image=(GtkWidget ***)malloc(dim_x*sizeof(GtkWidget **));
 case_click=(x_y **)malloc(dim_x*sizeof(x_y *));
 pous=(unsigned short **)malloc(dim_x*sizeof(unsigned short *));
 for (i=0;i<dim_x;i++)
 {
  pourdessin[i]=(GdkPixbuf **)malloc(dim_y*sizeof(GdkPixbuf *));
  case_table[i]=(GtkWidget **)malloc(dim_y*sizeof(GtkWidget *));
  image[i]=(GtkWidget **)malloc(dim_y*sizeof(GtkWidget *));
  case_click[i]=(x_y *)malloc(dim_y*sizeof(x_y));
  pous[i]=(unsigned short *)malloc(dim_y*sizeof(unsigned short));
  for(j=0;j<dim_y;j++)
  {
   case_click[i][j].x=i;
   case_click[i][j].y=j;
   pous[i][j]=i*dim_y+j;
   image[i][j]=gtk_image_new_from_file("noir.png");
  }
 }
}

 
void morceaux()
{
 unsigned short i,j;
 float rapport;
 GError **error=NULL;
 GdkPixbuf* tmp;
 
 tmp=gdk_pixbuf_new_from_file(fichier,error);
 rapport = (float)TAILLE/gdk_pixbuf_get_width (tmp);
 if (rapport>=1) rapport=1; /* on n'agrandira pas l'image */
 taille_y = gdk_pixbuf_get_height (tmp)*rapport;
 /* http://developer.gnome.org/doc/API/2.0/gdk-pixbuf/gdk-pixbuf-scaling.html#gdk-pixbuf-scale */
 if (rapport<1)
 {
  /* diminution de l'image */
  gdk_pixbuf_scale(tmp,tmp,0,0,TAILLE,taille_y,0,0,rapport,rapport,GDK_INTERP_HYPER);
  dessin=gdk_pixbuf_new_subpixbuf(tmp,0,0,TAILLE,taille_y);
 /* http://developer.gnome.org/doc/API/2.0/gdk-pixbuf/gdk-pixbuf-gdk-pixbuf.html */
  taille_x=TAILLE/dim_x;
 }
 else /* rapport == 1 */
 {
  taille_x=gdk_pixbuf_get_width (tmp)/dim_x;
  dessin=gdk_pixbuf_copy(tmp);
 }
 taille_y/=dim_y;
 for(i=0;i<dim_x;i++)
 {
  for(j=0;j<dim_y;j++)
  {
   if (i==0 && j==0) /* le trou */
   {
     pourdessin[0][0]=gdk_pixbuf_new_from_file_at_scale("noir.png",taille_x,taille_y,FALSE,error); /* fond noir pour repérage plus facile */
     gdk_pixbuf_scale(tmp,pourdessin[0][0],taille_x/4,taille_y/4,taille_x/2,taille_y/2,taille_x/4,taille_y/4,1./2,1./2,GDK_INTERP_HYPER);
   }
   else
   {
    pourdessin[i][j]=gdk_pixbuf_new_subpixbuf(tmp,i*taille_x,j*taille_y,taille_x,taille_y);
   }
  }
 }
 /*petite=gdk_pixbuf_copy (tmp);*/
 if (taille_x>(TAILLE/(6*dim_x))) /* TAILLE/(6*dim_x) : taille prévu pour la miniature de l'image */
 {                                /* normalement on devrait toujours passer par là, sinon, l'image choisit est trop petite */
  petite=gdk_pixbuf_scale_simple(tmp,TAILLE/6,taille_y/6*dim_y,GDK_INTERP_HYPER);
  petite=gdk_pixbuf_new_subpixbuf(petite,0,0,TAILLE/6,taille_y/6*dim_y);
 }
 else
  petite=gdk_pixbuf_copy (tmp);
}

void signal_morceaux() /* affichage des dessins dans les cases et */
{ /* affectation de la fonction callback_label avec le paramètre case_click[i][j] ou (i,j) à la case (i,j) */
 unsigned short i,j;
 
 for (i=0;i<dim_x;i++)
 {
  for(j=0;j<dim_y;j++)
  {
   gtk_image_set_from_pixbuf(GTK_IMAGE(image[i][j]),pourdessin[pous[i][j]/dim_y][pous[i][j]%dim_y]);
   case_table[i][j]=gtk_event_box_new();
   gtk_container_add(GTK_CONTAINER(case_table[i][j]),image[i][j]);
   gtk_widget_add_events(case_table[i][j],GDK_BUTTON_PRESS_MASK);
   g_signal_connect(G_OBJECT(case_table[i][j]), "button_press_event", G_CALLBACK(callback_label), &case_click[i][j]);
   /*gtk_table_attach(GTK_TABLE(table),case_table[i][j],i,i+1,j,j+1,GTK_SHRINK,GTK_SHRINK,0,0);*/
   gtk_table_attach_defaults(GTK_TABLE(table),case_table[i][j],i,i+1,j,j+1);
  }
 }
}

void choix_fichier()
{
 /* boite de dialogue */
 GtkWidget *dialogue = NULL;
 GError * error;

 fichier="20041203_laMouette-Vole.png";
 /* http://developer.gnome.org/doc/API/2.0/gtk/GtkFileChooserDialog.html#gtk-file-chooser-dialog-new */
 dialogue=gtk_file_chooser_dialog_new_with_backend("Choix de l'image",NULL,GTK_FILE_CHOOSER_ACTION_OPEN,GTK_STOCK_CANCEL,"la Mouette", GTK_RESPONSE_CANCEL,GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,NULL);
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"pouspous.ico",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 if (gtk_dialog_run (GTK_DIALOG (dialogue)) == GTK_RESPONSE_ACCEPT)
  fichier = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER (dialogue));
 gtk_widget_destroy (dialogue);
}

void traite_erreur(GError *error)
{
 printf("%s\n",error->message);                                      /* affichage de l'erreur                                       */
}

