#include <string.h>
#include <stdio.h>
#include<gtk/gtk.h>

void traite_erreur(GError *error)
{
 printf("%s\n",error->message);                                      /* affichage de l'erreur                                       */
}

char recherche(char * chaine_cherchee,char * chaine, char c,char * drap)
{
 int i;
 char ok=0;
 char aff_chaine[420];
 
 i=0;
 while(chaine_cherchee[i])                                         /* tant qu'on n'est pas en bout de chaine                        */
 {
  if (chaine_cherchee[i]==c && chaine[i]!=c)                       /* si le chiffre choisit est présent et pas encore affiché       */
  {
   *drap=1;                                                        /* on signale qu'on a au moins un bon chiffre                    */
   strcpy(aff_chaine,chaine+i+1);                                  /* on met le chiffre dans la chaine affichée, mais on le met en  */
   chaine[i]=0;                                                    /* rouge                                                         */
   sprintf(chaine,"%s<span foreground=\"#c00000\">%c</span>%s\0",chaine,c,aff_chaine);
   strcpy(aff_chaine,chaine_cherchee+i+1);                         /* ceci allonge la chaine affichée : on fait de même avec la     */
   chaine_cherchee[i]=0;                                           /* chaine cherchée pour pouvoir encore faire la comparaison      */
   sprintf(chaine_cherchee,"%s<span foreground=\"#c00000\">%c</span>%s\0",chaine_cherchee,c,aff_chaine);
  }                                                                /* la mise en page est faite avec des chiffres en minuscule      */
  ok+=(chaine[i]>='A' && chaine[i]<='Z');                          /* reste t'il des majuscules dans l'affichage                    */
  i++;
 }

 return ok;
}

void code(char * chaine,char * chaine_cherchee)
{
 char tab1[26];
 unsigned int tab2[26];
 char aff_chaine[70];
 unsigned short i,j,n=0,m;
 
 for (i=0;i<26;i++)
 {                                                                  /* Fabrication de deux tableaux                                 */
  tab1[i]=i+'A';                                                    /* Le premier avec les lettres de A à Z                         */
  tab2[i]=rand();                                                   /* Le second avec un tirage aléatoire                           */
 }
 
 for (i=0;i<10;i++)                                                 /* astuce : pas besoin d'aller plus loin que les 10 premiers    */
 {
  n=i;                                                              /* Je vais mettre le plus petit devant le tableau, chaque fois, */
  m=tab2[i];                                                        /* je vais commencer une case plus loin pour avoir un classement*/
  for (j=i+1;j<26;j++)                                              /*Cette méthode doit être valable ici : je ne classe que les dix*/
  {                                                                 /* plus petit. L'arbre binaire plus rapide pour les classer tous*/
   if (m>tab2[j])                                                   /* doit être plus lent ici.                                     */
   {                                                                /* Je retiens la place du plus actit et sa valeur dans n et m   */
    n=j;                                                            /* Au début, je les initialise avec le premier élément, puis dès*/
    m=tab2[j];                                                      /* que je trouve plus petit, je mémorise.                       */
   }
  }
  tab2[n]=tab2[i];                                                  /* Je place le plus petit devant, la variable m sert de tampon  */
  tab2[i]=m;                                                        /* certes, juste tab2[i]=tab2[m] est ici suffisant...           */
  m=tab1[n];
  tab1[n]=tab1[i];                                                  /* même manipulation avec tab1 afin de mélanger les lettres     */
  tab1[i]=m;
 }
 strcpy(chaine,chaine_cherchee);                                    /* copie de la chaine cherchée dans la chaine à afficher        */
 
 i=0;
 while(chaine[i])                                                   /* parcours de la chaine à afficher pour remplacer les chiffres */
 {                                                                  /* par les lettres, uniquement les chiffres, pas les espaces et */
  if (chaine[i]>='0' && chaine[i]<='9')                             /* signes.                                                      */
   chaine[i]=tab1[chaine[i]-'0'];                                   /*chaine[i]-0 donne la valeur du chiffre dont on a le code ASCII*/
  i++;
 }
}

void fenetre_nom(char * nom ,char * mes)
{
 /* boite de dialogue */
 GtkWidget *dialogue = NULL;
 GtkWidget *d_label = NULL;
 GtkWidget *lar = NULL;
 GtkWidget *xl = NULL;
 GtkWidget *fois = NULL;
 GtkWidget *yh = NULL;
 unsigned i,j;
 char ch[32];
 GError *error = NULL;
 
 dialogue=gtk_dialog_new_with_buttons("Nom Prénom",NULL, GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_OK,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"troumad.ico",&error))
 {                                                                 /* met une icone à la fenêtre                                    */
  traite_erreur(error);
  free(error);
 }
 /* création d'un label (espace de texte) avec un texte simple, sans formatage */
 d_label=gtk_label_new(mes);
 /* insertion du label dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),d_label, TRUE, TRUE, 0);
 /* création d'un conteneur horizontal : lar */
 lar = gtk_hbox_new (FALSE, 0);
 /* insertion du conteneur lar dans le conteneur principal */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),  GTK_WIDGET (lar), TRUE, TRUE, 0);
 /* création de la première boite de dialogue : pour le prénom */
 xl=gtk_entry_new();
 gtk_entry_set_text(GTK_ENTRY(xl),g_locale_to_utf8 (g_get_user_name(), -1, NULL, NULL,&error)); /* transforme en utf8 le code local   */
 if (error!=NULL)                                                  /* pour un affichage avec gtk                                      */
 {
  traite_erreur(error);                                            /* traite une erreur possible de la conversion                     */
  free(error);
 }
 gtk_entry_set_max_length(GTK_ENTRY(xl),14);
 /* insertion de cette boite dans lar */
 gtk_box_pack_start (GTK_BOX (lar),  GTK_WIDGET (xl), FALSE, FALSE, 0);
 /* boite de dialogue pour le paramètre nom : même topo que pour prénom */
 yh=gtk_entry_new();
 gtk_entry_set_text(GTK_ENTRY(yh),g_locale_to_utf8 (g_get_real_name(), -1, NULL, NULL,&error));
 if (error!=NULL)
 {
  traite_erreur(error);
  free(error);
 }
 gtk_entry_set_max_length(GTK_ENTRY(yh),14);
 gtk_box_pack_start (GTK_BOX (lar), GTK_WIDGET (yh), FALSE,FALSE, 0);
 
 /* obligatoire pour afficher le contenu de la boite de dialogue */
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 /* On lance la boite de dialogue */
 switch (gtk_dialog_run(GTK_DIALOG(dialogue)))
 {
  case GTK_RESPONSE_NONE:
      printf("case GTK_RESPONSE_NONE:\n");
  case GTK_RESPONSE_CANCEL:
      gtk_widget_destroy(dialogue);
      break;
  case GTK_RESPONSE_OK:
      /* on récupère les nombres rentrés dans ces boites de dialogue */
      sprintf(nom,"traces/%s_%s.pendu",gtk_entry_get_text(GTK_ENTRY(xl)),gtk_entry_get_text(GTK_ENTRY(yh)));
      gtk_widget_destroy(dialogue);
      break; /* inutile normalement */
  default :
      gtk_widget_destroy(dialogue);
      printf("default:\n"); /* normalement, on ne passe pas par là */
 }
}

void cd_prog(char * appel)
{
 char      * chemin;

 chemin=g_dirname(appel);                                         /* récupération du chemin vers la commande (exécutable)         */

 chdir(chemin);
 free(chemin);
}


GtkWidget * label_licence()
{
 GtkWidget * label;
 GError *error = NULL;

 label=gtk_label_new("Copyright (c) 2007 Bernard SIAUD.\n\nPermission is granted to copy, distribute and/or modify this document under the terms of the GNU Free Documentation License, Version 1.2 or any later version published by the Free Software Foundation; with no Invariant Sections, no Front-Cover Texts, and no Back-Cover Texts. A copy of the license is included in the section entitled  \"GNU Free Documentation License\" :  http://www.gnu.org/licenses/fdl.txt");
 
 return label;
}
