#include "lecture.h"
#include <errno.h>
#include "commun.h"

int main(int argc, char **argv)
{
 GtkWidget *total = NULL;                                          /* le conteneur principal                                        */
 GtkWidget *p_window = NULL;                                       /* la fenêtre                                                    */
 GtkWidget **p_label = NULL;                                       /* le tableau de texte                                           */
 GtkWidget * ascenseur_text=NULL;
 GtkWidget * ascenseur_label=NULL;
 GtkWidget * ascenseur_licence=NULL;
 GtkWidget * zone_label=NULL;
 GtkWidget * zone_texte=NULL;
 GtkWidget * zone_licence=NULL;
 GtkWidget * licence=NULL;
 char chaine[420];                              /* chaine affichée et chaine cherchée pour l'opération sur laquelle on travaille    */
 char chaine_cherchee[420];                     /* Elles sont énormes à cause des effets de style ajoutés pour une meilleure vision */
 GtkWidget * affiche_texte=NULL;
 GtkTextBuffer *texte1 = NULL;
 GtkTextIter iter;
 GtkTextTag * tag_operation;
 GtkTextTag * tag_nombre;
 GtkTextTag * tag_presentation;
 PangoFontDescription * style;
 GError *error=NULL;
 
 GtkWidget *onglet = NULL;
 

 FILE * fichier;
 char * texte=NULL;
 char ligne[46],ch[420];
 int l1,l=0;
 int i,j;
 char c;
 int nb_label=0;
 char nb[3]=" 0";

 gtk_init (&argc, &argv); 

 ligne[0]=0;
 fenetre_nom(ligne,"Quel nom d'élève ?");
 if (ligne[0]==0)
  strcpy(ligne,"traces/sortie.pendu");

 /*affiche_texte=gtk_text_view_new();
 texte1=gtk_text_view_get_buffer(GTK_TEXT_VIEW(affiche_texte));*/   /* ferait la même chose que les deux lignes suivantes           */

 texte1=gtk_text_buffer_new(NULL);
 affiche_texte=gtk_text_view_new_with_buffer(texte1);               /* on définit affiche texte comme étant le widget qui affichera */
 gtk_text_view_set_editable(GTK_TEXT_VIEW(affiche_texte),FALSE);    /* le texte du buffer texte1 qui sera non modifiable            */
 tag_operation=gtk_text_buffer_create_tag(texte1, "tag_operation", "foreground", "red", NULL); /* création de tag pour le formatage */
 tag_nombre = gtk_text_buffer_create_tag(texte1, "tag_nombre", "foreground", "blue", NULL);  /* de l'écriture dans la fenêtre texte */
 style=pango_font_description_new();                                /* création d'un style pour mettre dans un formatage            */
 pango_font_description_set_style (style,PANGO_STYLE_ITALIC);       /* le passage par PangoFontDescription est inutile car on peut  */
 pango_font_description_set_weight (style,PANGO_WEIGHT_ULTRABOLD);  /* tout mettre directement dans le gtk_text_buffer_create_tag   */
 tag_presentation = gtk_text_buffer_create_tag(texte1,"tag_presentation","font-desc",style,"background","black", "foreground", "white","underline",PANGO_UNDERLINE_SINGLE, NULL);
 

 p_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);                    /* mise ne place de la fenêtre principale                       */
 if (p_window==NULL) return 0;                                      /* mise en place impossible => sortie du programme              */
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (p_window),"troumad.ico",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 gtk_window_resize(GTK_WINDOW (p_window),450,600);
 gtk_window_set_title (GTK_WINDOW (p_window),"Pendu Mathématique"); /* titre de la fenêtre                                          */
 total=gtk_vbox_new(FALSE,0);                                       /* boite horizontale principale                                 */
 gtk_container_add (GTK_CONTAINER (p_window), total);               /* insertion de la boite horizontale dans la principale *       */
 
 onglet=gtk_notebook_new ();                                        /* on va avoir des onglets                                      */
 gtk_container_add (GTK_CONTAINER (total),onglet);

 zone_label=gtk_vbox_new(FALSE,0);                                  /* premier onglet : affichage des traces sous forme de label    */
 ascenseur_label=gtk_scrolled_window_new (NULL, NULL);              /* on met des ascenseurs                                        */
 gtk_container_add (GTK_CONTAINER (onglet),ascenseur_label);        /* dans les onglets                                             */
 gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ascenseur_label), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC); 
                                                                    /*  On affiche les ascenseurs que si c'est utile                */
 gtk_notebook_set_tab_label(GTK_NOTEBOOK(onglet),ascenseur_label,GTK_WIDGET (gtk_label_new ("Progression")));
                                                                    /* On donne un nom à l'onglet                                   */
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ascenseur_label),zone_label);
                                                                    /*insertion d'une zone label pour mettre des label dans l'onglet*/

 ascenseur_text=gtk_scrolled_window_new (NULL, NULL);
 gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ascenseur_text), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
 gtk_notebook_append_page(GTK_NOTEBOOK(onglet),GTK_WIDGET(ascenseur_text),GTK_WIDGET (gtk_label_new ("Zone Texte")));
 zone_texte=gtk_vbox_new(FALSE,0);
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ascenseur_text),zone_texte);

 zone_licence=gtk_vbox_new(FALSE,0);
 ascenseur_licence=gtk_scrolled_window_new (NULL, NULL);
 gtk_container_add (GTK_CONTAINER (onglet),ascenseur_licence);
 gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (ascenseur_licence), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC); 
 gtk_notebook_set_tab_label(GTK_NOTEBOOK(onglet),ascenseur_licence,GTK_WIDGET (gtk_label_new ("Licence")));
 gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(ascenseur_licence),zone_licence);
 licence=label_licence();
 gtk_label_set_line_wrap(GTK_LABEL(licence),TRUE);                  /* label avec saut de ligne                                     */
 gtk_box_pack_start (GTK_BOX(zone_licence),licence, TRUE, TRUE, 0); /* insertion du label dans le conteneur principal               */
 gtk_label_set_justify(GTK_LABEL(licence),GTK_JUSTIFY_CENTER);      /* le label sera centré                                         */
 
 fichier=fopen(ligne,"r");
 if (fichier==NULL)
 {
  perror (NULL);
  printf("\nFichier %s impossible à ouvrir.\n",ligne);
  return 0;
 }                                 /* définition du fichier de sortie                               */

 while (fgets(ligne,40,fichier)!=NULL)                        /* tant que la fin n'est pas arrivée */
 {
  l1=l+strlen(ligne);
  texte=(char *)realloc(texte,l1+1);
  strcpy(texte+l,ligne);
  l=l1;
 }
/*printf("%s\n",texte);*/
 for(l1=0,l=0;texte[l1]!=0;l1++,l++)
 {
  while (texte[l1]==' ' || texte[l1]=='\n') /* suppression des espaces et saut de ligne */
  {
   l1++;                                 /* retour de 1 en arrière pour être à la même place le tour suivant */
  }
  texte[l]=texte[l1];
 }
/*printf("%s\n",texte);*/

 l=0;
 while((l1=partie(texte+l))) /* texte + l    : début de la partie */
 {                          /* texte+l1+l   : début des instructions de la partie */
  l+=l1;
  l+=operation(texte+l,ligne);
  if(sscanf(ligne,"%d%c%d",&i,&c,&j)!=3) {printf("%s : mauvaise lecture\n",ligne);return 0;}
  switch (c)
  {
   case '+' : sprintf(chaine_cherchee,"%d+%d=%d",i,j,i+j);break;
   case '-' : sprintf(chaine_cherchee,"%d-%d=%d",i,j,i-j);break;
   case '*' : sprintf(chaine_cherchee,"%d*%d=%d",i,j,i*j);break;
   case '/' : sprintf(chaine_cherchee,"%d/%d=%d",i,j,i/j);break;
   default : printf("%c : mauvais signe\n",c); return 0;
  }
  sprintf(ch,"opération : %s\n",chaine_cherchee);

  gtk_text_buffer_get_end_iter(texte1,&iter);
  gtk_text_buffer_insert_with_tags(texte1,&iter,"  ",2,NULL);
  gtk_text_buffer_get_end_iter(texte1,&iter);
  gtk_text_buffer_insert_with_tags(texte1,&iter,"\n opération : ",14,tag_presentation,NULL);
  gtk_text_buffer_get_end_iter(texte1,&iter);
  gtk_text_buffer_insert_with_tags(texte1,&iter," ",1,NULL);
  gtk_text_buffer_get_end_iter(texte1,&iter);
  gtk_text_buffer_insert_with_tags(texte1,&iter,chaine_cherchee,strlen(chaine_cherchee),tag_operation,NULL);
  gtk_text_buffer_get_end_iter(texte1,&iter);
  gtk_text_buffer_insert_with_tags(texte1,&iter,"\n",1,NULL);
  gtk_text_buffer_get_end_iter(texte1,&iter);
  gtk_text_buffer_insert_with_tags(texte1,&iter,"nombres proposés :",19,NULL);

  /* http://www.gtk-fr.org/wakka.php?wiki=LesZonesDeTexte */
  nb_label++;
  p_label=(GtkWidget **)realloc(p_label,nb_label*sizeof(GtkWidget *));
  p_label[nb_label-1]=gtk_label_new(ch);
  ch[0]=0;
  gtk_box_pack_start(GTK_BOX(zone_label),p_label[nb_label-1],TRUE,TRUE,0);
  code(chaine,chaine_cherchee);
  nb_label++;
  p_label=(GtkWidget **)realloc(p_label,nb_label*sizeof(GtkWidget *));
  p_label[nb_label-1]=gtk_label_new(chaine);
  gtk_box_pack_start(GTK_BOX(zone_label),p_label[nb_label-1],TRUE,TRUE,0);
  while(l1=isole_choix(texte+l,&i))
  {
   l+=l1;
   sprintf(ch,"%s %d",ch,i);

   gtk_text_buffer_get_end_iter(texte1,&iter);
   nb[1]='0'+i;
   gtk_text_buffer_insert_with_tags(texte1,&iter,nb,2,tag_nombre,NULL);

   c=0;
   recherche(chaine_cherchee,chaine,i+'0',&c);
   if (c)
   {
    sprintf(ch,"%s %s",ch," => ");
    nb_label++;
    p_label=(GtkWidget **)realloc(p_label,nb_label*sizeof(GtkWidget *));
    p_label[nb_label-1]=gtk_label_new("");
    gtk_label_set_markup(GTK_LABEL(p_label[nb_label-1]),strcat(ch,chaine));
    gtk_box_pack_start(GTK_BOX(zone_label),p_label[nb_label-1],TRUE, TRUE,0);
    ch[0]=0;
   }
  }
  nb_label++;
  p_label=(GtkWidget **)realloc(p_label,nb_label*sizeof(GtkWidget *));
  p_label[nb_label-1]=gtk_label_new(ch);
  gtk_box_pack_start(GTK_BOX(zone_label),p_label[nb_label-1],TRUE, TRUE,0);

  l+=isole_partie(texte+l); /* texte+l1+l   : fin de la partie */
  gtk_text_buffer_get_end_iter(texte1,&iter);
  gtk_text_buffer_insert_with_tags(texte1,&iter,"\n",1,NULL);

 }
 
 gtk_box_pack_start(GTK_BOX(zone_texte),affiche_texte,TRUE, TRUE, 0);
 
 g_signal_connect (G_OBJECT (p_window), "destroy", G_CALLBACK (cb_fin),NULL);/*appel de cb_fin si destruction de la boite principale*/

 gtk_widget_show_all (p_window);                             /* on active l'affichage la boite principale et tout ce qui est dedans */
 
 gtk_main ();                                                      /* on active la boite principale : le jeu est lancé              */

 return 1;
}
