#include "pendu.h"
#include "commun.h"

                                                                   /* nom des images qui composent le PENDU                         */
char nom[NB_MORCEAUX][13]= {"socle.png","potence1.png","potence2.png","potence3.png","corde.png","tete.png","corps.png","bras.png","pied.png"};
char signe[5]="+-*/";                                              /* les 4 opérations                                              */
char chaine[420];                               /* chaine affichée et chaine cherchée pour l'opération sur laquelle on travaille    */
char chaine_cherchee[420];                      /* Elles sont énormes à cause des effets de style ajoutés pour une meilleure vision */
char operation='+';                                                /* mémorisation de l'opération choisie : + par défaut            */
unsigned char erreur=0;                                            /* nombre d'erreur ou avancement du PENDU                        */
unsigned char partie=0;                                            /* nombre de parties gagnées sans avoir été PENDU                */


void cb_fin(GtkWidget *p_widget, gpointer * donnees)
{	
  gtk_main_quit();                                                  /* on efface la boite principale                                */
  fclose(FICHIER);                                                  /* on ferme le FICHIER de sortie                                */
  
 /* parametres inutilises */
 (void)p_widget;                                                    /* pour éviter des warning lors de la compilation               */
}

void cb_erreur(GtkWidget *p_widget, gpointer donnees,char * trace)    /* fonction appelée lors d'un echec                             */
{                                                                   /* trace est le paramètre passé pour identifier l'erreur        */
 printf("Erreur dans une fonction : %s. Fin prématurée du programme\n",trace);
 
 cb_fin(p_widget,donnees);
}

void menu_addWidget (GtkUIManager * p_uiManager, GtkWidget * p_widget, GtkContainer * p_box)
{                                                                   /* procédure pour activer le menu                               */
   gtk_box_pack_start (GTK_BOX (p_box), p_widget, FALSE, FALSE, 0);
   gtk_widget_show (p_widget);
   return;

   (void)p_uiManager;
}

void menu_aide(GtkWidget *p_widget, gpointer * donnees)
{
 GtkWidget *dialogue = NULL;                                        /* Cette fois on va afficher uniquement une boite de dialogue   */
 GtkWidget *d_label1 = NULL;                                        /* avec un label                                                */
 GError *error = NULL;

 dialogue=gtk_dialog_new();
 if (dialogue==NULL) return;                                        /* sortie en cas erreur                                         */
 gtk_window_set_title(GTK_WINDOW(dialogue),"Aide");
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"troumad.ico",&error))
 {                                                                 /* met une icone à la fenêtre                                    */
  traite_erreur(error);
  free(error);
 }
 gtk_window_set_default_size(GTK_WINDOW(dialogue),300,-1);          /* on impose la largeur                                         */
 /* création d'un label (espace de texte) avec un texte simple, sans formatage, mais avec des codes bizares comme é,ê... :          */
 /*      utilisation de g_locale_to_utf8 est devenu inutile car le code source est en utf8                                          */ d_label1=gtk_label_new("\nVous devez reconstituer l'opération dans laquelle les chiffres ont été remplacés par des lettres.\nChaque erreur est comptée et vous rapproche de la pendaison !\n\nEssayer de faire le plus de partie possible avant d'être PENDU ;-)\n\n\nVous avez la possibilité de changer l'opération.\nIl est possible de faire :\n   - une addition (+)\n   - une soustraction (-)\n   - une multiplication (*)\n   - une division entière (/) dont le reste est nul.\nIl est aussi possible de changer l'opération en cours.\n\n\nEnsuite, vous avez le programme lecture_pendu pour lire les traces ou historiques des parties.");
 if (d_label1==NULL) return;
 gtk_label_set_line_wrap(GTK_LABEL(d_label1),FALSE);                /* définition du mode de retour à la ligne                      */
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label1, TRUE, TRUE, 0); /* insertion du label dans la boite            */
 
 gtk_label_set_justify(GTK_LABEL(d_label1),GTK_JUSTIFY_CENTER);     /* affichage du texte : centré                                  */
 
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);                   /* tous les item seront visibles                                */
 gtk_dialog_run(GTK_DIALOG(dialogue));                              /* On lance la boite de dialogue                                */
}

void menu_a_propos(GtkWidget *p_widget, gpointer * donnees)
{
 GtkWidget *dialogue = NULL;                                        /* rien de nouveau depuis tout à l'heure, rien de plus          */
 GtkWidget *d_label = NULL;
 GError *error = NULL;

 dialogue=gtk_dialog_new();
 if (dialogue==NULL) return;                                        /* sortie en cas erreur                                         */
 gtk_window_set_title(GTK_WINDOW(dialogue),"A Propos");
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"troumad.ico",&error))
 {                                                                 /* met une icone à la fenêtre                                    */
  traite_erreur(error);
  free(error);
 }
 gtk_window_set_default_size(GTK_WINDOW(dialogue),300,-1);
 d_label=gtk_label_new("PENDU Mathématique\npar\nTroumad Alias Bernard SIAUD\nhttp://troumad.org");

 if (d_label==NULL) return;                                         /* sortie en cas erreur                                         */
 gtk_label_set_line_wrap(GTK_LABEL(d_label),FALSE);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label, TRUE,TRUE, 0);
 gtk_label_set_justify(GTK_LABEL(d_label),GTK_JUSTIFY_CENTER);
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 gtk_dialog_run(GTK_DIALOG(dialogue));
}

void menu_licence(GtkWidget *p_widget, gpointer * donnees)
{
 GtkWidget *dialogue = NULL;                                        /* rien de nouveau depuis tout à l'heure, rien de plus          */
 GtkWidget *d_label = NULL;                                         /* il y juste 2 labels                                          */
 GtkWidget *d_label1 = NULL;
 GError *error = NULL;

 dialogue=gtk_dialog_new();
 if (dialogue==NULL) return;                                        /* sortie en cas erreur                                         */
 gtk_window_set_title(GTK_WINDOW(dialogue),"Licence GPL");
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"gnu-head-mini.png",&error))
 {                                                                  /* met une icone à la fenêtre                                   */
  traite_erreur(error);
  free(error);
 }
 gtk_window_set_default_size(GTK_WINDOW(dialogue),300,-1);
 /* création d'un label (espace de texte) avec un texte simple, sans formatage */
 d_label=label_licence();

 if (d_label==NULL) return;
 d_label1=gtk_label_new("\n\nVersion française non officielle : http://fsffrance.org/gpl/gpl.fr.html");
 if (d_label1==NULL) return;
 gtk_label_set_line_wrap(GTK_LABEL(d_label),TRUE);                  /* label avec saut de ligne                                     */
 gtk_label_set_line_wrap(GTK_LABEL(d_label1),TRUE);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label, TRUE, TRUE, 0);/* insertion du label dans le conteneur principal*/
 gtk_label_set_justify(GTK_LABEL(d_label),GTK_JUSTIFY_CENTER);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox), d_label1, TRUE, TRUE, 0);
 gtk_label_set_justify(GTK_LABEL(d_label1),GTK_JUSTIFY_CENTER);
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 /* On lance la boite de dialogue */
 gtk_dialog_run(GTK_DIALOG(dialogue));
}

void nv_operation(GtkWidget *a, gpointer * donnees)
{
 int i;                                                            /* pour le parcours des tableaux, il faut un int                 */
 GtkWidget *dialogue = NULL;                                       /* utilisation d'une nouvelle boite de dialogue avec des boutons */
 GtkWidget *d_label = NULL;
 GtkWidget *d_label1 = NULL;
 GtkWidget * combo=NULL;
 GtkWidget * hor1=NULL;
 char * ch;
 GError *error = NULL;

   /* on donne 1) le nom de la boite, 2) le nom du processus père, 3) une liste bouton/signal de sortie 4) NULL pour finir la liste */
 dialogue=gtk_dialog_new_with_buttons("Opération du PENDU",NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_OK,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);
 if (dialogue==NULL) cb_erreur(a,donnees,"nv_operation dialogue");
 if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"troumad.ico",&error))
 {                                                                 /* met une icone à la fenêtre                                    */
  traite_erreur(error);
  free(error);
 }
 hor1=gtk_hbox_new(TRUE,0);
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),hor1, TRUE, TRUE, 0);
 d_label=gtk_label_new("Choisissez une des 4 operations.");
 if (d_label==NULL) cb_erreur(a,donnees,"nv_operation d_label");
 gtk_box_pack_start (GTK_BOX (hor1),d_label, TRUE, TRUE, 0);
 
 /****************************************/
 /* mise en place de la liste déroulante */
 /****************************************/
 combo = gtk_combo_box_new_text();                                 /* liste déroulante                                              */
 if (combo==NULL) cb_erreur(a,donnees,"nv_operation combo");
 for (i=0;i<4;i++)                                                 /* on mettre 4 items dans la liste déroulante                    */
 {
  gtk_combo_box_append_text(GTK_COMBO_BOX(combo),ch=g_strdup_printf("%c",signe[i]));/*fabrication de la chaine à afficher           */
  free(ch);                                                        /* g-strdup-printf réserve la place, on la libère                */
 }
 gtk_combo_box_set_active(GTK_COMBO_BOX(combo),0);                 /* on choisit l'entrée qui sera sélectionnée au début            */
 gtk_box_pack_start(GTK_BOX(hor1),combo,TRUE,TRUE,0);
 gtk_widget_set_size_request(combo,30,-1);
 
 d_label1=gtk_label_new("Ce choix ne sera effectif qu'à la prochaine opération.");
 if (d_label1==NULL)
 {
  printf("nv_opération, Erreur d_label1\n");
 }
 gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),d_label1, TRUE, TRUE, 0);
 
 gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
 switch (gtk_dialog_run(GTK_DIALOG(dialogue)))                     /* lors de la sortie de la boite de dialogue, en fonction de la  */
 {                                                                 /* méthode utilisée pour fermer la boite, on va agir différemment*/
  case GTK_RESPONSE_NONE:                                          /* fermeture de fenêtre                                          */
  case GTK_RESPONSE_CANCEL:                                        /* bouton CANCEL                                                 */
      gtk_widget_destroy(dialogue);                                /* on ferme la boite                                             */
      break;
  case GTK_RESPONSE_OK:
  /************************************/
  /*  lecture de la liste déroulante  */
  /************************************/                           /* bouton OK : on récupère l'opération choisie dans la liste     */
      ch=gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo));      /* déroulante dans une chaîne qu'on analyse                      */
      operation=ch[0];
      free(ch);                                                    /* il faut libérer la place après                                */

      gtk_widget_destroy(dialogue);
      break;
  default :                                                        /* affiche un message si je n'ai pas pensé à tout                */
      gtk_widget_destroy(dialogue);
      printf("default : erreur proc nv_operation\n");              /* normalement, on ne passe pas par là                           */
 }
}

int valide(GtkWidget * a, gpointer * donnees)                      /* fonction appelée lors du jeu pour valider un choix de nombre  */
{
 GtkWidget *dialogue = NULL;
 GtkWidget *d_label = NULL;
 GtkWidget *d_label1 = NULL;
 GtkWidget *hor1 = NULL;
 char ok=0,drap=0;
 GdkPixbuf * morceaux = NULL;
 GError *error=NULL;
 gchar * chiffre, *ch;
 char aff_chaine[420];
 GtkWidget * combo=NULL;
 int i;

 if (gtk_combo_box_get_active_text(GTK_COMBO_BOX(COMBO))!=NULL)
 {
  chiffre=gtk_combo_box_get_active_text(GTK_COMBO_BOX(COMBO));     /* récupération de la chaine affichée dans le bouton sélectionné */

  ok=recherche(chaine_cherchee,chaine,chiffre[0],&drap);           /* recherche chiffre[0] dans chaine_cherchee, retour nb de modif */
                                                                   /* modifie chaine_cherchee et chaine pour l'affichage            */
  fprintf(FICHIER," <nb>%c</nb>\n",chiffre[0]);                    /* écriture du nombre choisit dans le FICHIER de sortie pour     */
                                                                   /* pouvoir reconstituer la partie                                */
  if (drap)                                                        /* si le nombre choisit était bon                                */
  {
   sprintf(aff_chaine,"<span font_family=\"Courier New\">%s</span>",chaine);
   gtk_label_set_markup(GTK_LABEL(AFF_OPERATION),aff_chaine);      /* affichage de la chaine en courrier pour l'alignement          */
  }
  else
  {
   morceaux=gdk_pixbuf_new_from_file(nom[erreur],&error);          /* sinon on ajoute un morceau au PENDU                           */
   if (morceaux==NULL)                                             /* si aucun pixbuf n'a pu être chargé                            */
   {
    traite_erreur(error);                                          /* en cas d'erreur, j'affiche l'erreur                           */
    free(error);                                                   /* il faut libérer la place prise par la déclaration de l'erreur */
    cb_erreur(a,donnees,nom[erreur]);                              /* et je sors du programme                                       */
    return 0;                                                      /* avec un code d'erreur                                         */
   }
   gdk_pixbuf_composite(morceaux,VIDE,0,0,371,574,0,0,1,1,GDK_INTERP_BILINEAR,255); /* supperposition d'images dans le pixbuf       */
   gtk_image_set_from_pixbuf(GTK_IMAGE(PENDU),VIDE);               /* affichage du nouveau pixbull                                  */
   erreur++;                                                       /* une erreur de plus                                            */
  }
  gtk_combo_box_remove_text(GTK_COMBO_BOX(COMBO),gtk_combo_box_get_active(GTK_COMBO_BOX(COMBO))); /*on retire de la liste déroulante*/
  gtk_combo_box_set_active(GTK_COMBO_BOX(COMBO),0);                /* la case active : celle qu'on vient d'étudier                  */

  if (!ok)                                                         /* si la partie est gagnée                                       */
  {
   dialogue=gtk_dialog_new_with_buttons("Gagné! BRAVO",NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_OK,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);
   if (dialogue==NULL) cb_erreur(a,donnees,"valide dialogue");
   if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"troumad.ico",&error))
   {                                                               /* met une icone à la fenêtre                                    */
    traite_erreur(error);
    free(error);
   }
   d_label=gtk_label_new("Une autre partie ?\n");
   if (d_label==NULL) cb_erreur(a,donnees,"valide d_label");
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),d_label, TRUE, TRUE, 0);
   hor1=gtk_hbox_new(TRUE,0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),hor1, TRUE, TRUE, 0);
   d_label1=gtk_label_new("Opération du nouveau calcul :");
   if (d_label1==NULL) cb_erreur(a,donnees,"nv_operation d_label1");
   gtk_box_pack_start (GTK_BOX (hor1),d_label1, TRUE, TRUE, 0);
   combo = gtk_combo_box_new_text();                               /* liste déroulante                                              */
   if (combo==NULL) cb_erreur(a,donnees,"nv_operation combo");
   for (i=0;i<4;i++)                                               /* on mettre 4 items dans la liste déroulante                    */
   {
    gtk_combo_box_append_text(GTK_COMBO_BOX(combo),ch=g_strdup_printf("%c",signe[i]));/*fabrication de la chaine à afficher         */
    free(ch);                                                      /* g-strdup-printf réserve la place, on la libère                */
   }
   switch(operation)
   {
    case '+' :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),0);break;/* on choisit l'entrée + qui sera sélectionnée au début      */
    case '-' :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),1);break;/* on choisit l'entrée - qui sera sélectionnée au début      */
    case '*' :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),2);break;/* on choisit l'entrée * qui sera sélectionnée au début      */
    default  :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),3);break;/* on choisit l'entrée / qui sera sélectionnée au début      */
   }
   gtk_box_pack_start(GTK_BOX(hor1),combo,TRUE,TRUE,0);

   gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
   switch (gtk_dialog_run(GTK_DIALOG(dialogue)))                   /* proposition de refaire une nouvelle partie ou d'arrêter en    */
   {
    case GTK_RESPONSE_OK:                                          /* fonction du bouton choisit pour sortir de la boite de dialogue*/
  /************************************/
  /*  lecture de la liste déroulante  */
  /************************************/                           /* bouton OK : on récupère l'opération choisie dans la liste     */
       ch=gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo));     /* déroulante dans une chaîne qu'on analyse                      */
       operation=ch[0];
       free(ch);                                                   /* il faut libérer la place après                                */
       partie++;                                                   /* on incrémente le nombre de partie gagnées                     */
       gtk_widget_destroy(dialogue);
       nv_nombres(a,donnees);
       break;
    case GTK_RESPONSE_NONE:
    case GTK_RESPONSE_CANCEL:
    default :                                                      /* on ferme tout avec appel de la fonction finale                */
       fprintf(FICHIER,"</partie>\n");
       gtk_widget_destroy(dialogue);
       cb_fin(a,donnees);
   }
  }
 
  if (erreur==NB_MORCEAUX)                                         /* si la partie est perdu : même forme que précédemment          */
  {
   dialogue=gtk_dialog_new_with_buttons("Perdu ! PENDU !",NULL,GTK_DIALOG_MODAL,GTK_STOCK_OK,GTK_RESPONSE_OK,GTK_STOCK_CANCEL,GTK_RESPONSE_CANCEL,NULL);
   if (dialogue==NULL) cb_erreur(a,donnees,"valide dialogue erreur");
   else
   {
    if (!gtk_window_set_icon_from_file(GTK_WINDOW (dialogue),"troumad.ico",&error))
    {                                                              /* met une icone à la fenêtre                                    */
     traite_erreur(error);
     free(error);
    }
    sprintf(aff_chaine,"Perdu !\n\n%hu partie%c gagnée%c\nUne autre partie ?\n\nLa solution était\n<span font_family=\"Courier New\">%s</span>",partie,partie>1?'s':' ',partie>1?'s':' ',chaine_cherchee);
    d_label=gtk_label_new("");
    if (d_label==NULL) cb_erreur(a,donnees,"valide dialogue erreur");
    gtk_label_set_justify(GTK_LABEL(d_label),GTK_JUSTIFY_RIGHT);   /* imposition d'un alignement à droite                           */
    gtk_label_set_markup(GTK_LABEL(d_label),aff_chaine);
    hor1=gtk_hbox_new(TRUE,0);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),hor1, TRUE, TRUE, 0);
    d_label1=gtk_label_new("Opération du nouveau calcul :");
    if (d_label1==NULL) cb_erreur(a,donnees,"nv_operation d_label1");
    gtk_box_pack_start (GTK_BOX (hor1),d_label1, TRUE, TRUE, 0);
    combo = gtk_combo_box_new_text();                              /* liste déroulante                                              */
    if (combo==NULL) cb_erreur(a,donnees,"nv_operation combo");
    for (i=0;i<4;i++)                                              /* on mettre 4 items dans la liste déroulante                    */
    {     gtk_combo_box_append_text(GTK_COMBO_BOX(combo),ch=g_strdup_printf("%c",signe[i]));/*fabrication de la chaine à afficher         */
     free(ch);                                                     /* g-strdup-printf réserve la place, on la libère                */
    }
    switch(operation)
    {
     case '+' :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),0);break;/* on choisit l'entrée + qui sera sélectionnée au début     */
     case '-' :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),1);break;/* on choisit l'entrée - qui sera sélectionnée au début     */
     case '*' :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),2);break;/* on choisit l'entrée * qui sera sélectionnée au début     */
     default  :  gtk_combo_box_set_active(GTK_COMBO_BOX(combo),3);break;/* on choisit l'entrée / qui sera sélectionnée au début     */
    }
    gtk_box_pack_start(GTK_BOX(hor1),combo,TRUE,TRUE,0);
    gtk_box_pack_start (GTK_BOX (GTK_DIALOG(dialogue)->vbox),d_label, TRUE, TRUE, 0);
    gtk_widget_show_all(GTK_DIALOG(dialogue)->vbox);
    switch (gtk_dialog_run(GTK_DIALOG(dialogue)))
    {
     case GTK_RESPONSE_OK:
  /************************************/
  /*  lecture de la liste déroulante  */
  /************************************/                           /* bouton OK : on récupère l'opération choisie dans la liste     */
        ch=gtk_combo_box_get_active_text(GTK_COMBO_BOX(combo));    /* déroulante dans une chaîne qu'on analyse                      */
        operation=ch[0];
        free(ch);                                                  /* il faut libérer la place après                                */
        VIDE=gdk_pixbuf_new_from_file("vide.png",&error);          /* réinitialisation du pixbuff                                   */
        gtk_image_set_from_pixbuf(GTK_IMAGE(PENDU),VIDE);          /* réinitialisation de l'affichage du PENDU                      */
        nv_nombres(a,donnees);                                     /* demande de la nouvelle opération                              */
        gtk_widget_destroy(dialogue);
        erreur=0;
        partie=0;
        gtk_label_set_text(GTK_LABEL(AFF_PARTIE),"0 partie gagnée");/* début : partie 0                                             */
        break; 
     case GTK_RESPONSE_NONE:
     case GTK_RESPONSE_CANCEL:
     default :
        fprintf(FICHIER,"</partie>\n");                            /* fin du programme                                              */
        gtk_widget_destroy(dialogue);
        cb_fin(a,donnees);
    }
   }
  } 

  return 1;
 }
 else
 {
  printf("pas selection\n");
  return 0;
 }
}

void nouv_nombres(gpointer * donnees)                              /* tirages de la nouvelle opération                              */
{
 char aff_chaine[420];
 unsigned short i,j,n=0,m;
 char * ch;
 GError *error = NULL;
 unsigned short nb=1,nb1=1;
 
 nb=pow(10,(NB_CHIFFRES-1));
 nb1=9*nb;

 srand((unsigned int)time(NULL));
 i=rand()%nb1+nb;                                                  /* astuce pour avoir i à NB_CHIFFRE dont le premier ne soit pas 0*/
 if (operation=='*')
 {
  j=rand()%(nb1/100-1)+(nb/100+1);                                 /* on évite d'afficher 10 chiffres en tout : NB_CHIFFRE-2 pour j */
  n=i*j;                                                           /* et on évite le fois 1 qui est sans trop d'intérêt             */
 }
 else
 {
  j=rand()%(nb1/10)+(nb/10);                                       /* j aura un chiffre de moins que i, le premier n'étant pas 0    */
  switch (operation)                                               /* switch case : méthode très pratique pour trier                */
  {                                                                /* On fait l'opération choisie                                   */
   case '+' : n=i+j;break;
   case '-' : n=i-j;break;
   case '/' : n=i/j;i=n*j;break;                                    /* on annule le reste pour avoir une division exacte            */
  }
 }
 
 fprintf(FICHIER," <operation>%hu%c%hu</operation>\n",i,operation,j); /* mémoriser le minimum vital pour reconstituer la partie     */
 sprintf(chaine_cherchee,"%6hu\n%c        \n%6hu\n_________\n\n=%8hu",i,operation,j,n); /* fabriquer la chaîne de l'opération       */
 
 /*****************************/
 /*     VIDE le combo box     */
 /*****************************/
 i=1;                                                              /* drapeau pour la sortie de la liste                            */
 do
 {
  gtk_combo_box_set_active(GTK_COMBO_BOX(COMBO),0);                /* activation du premier élément                                 */
  if (gtk_combo_box_get_active_text(GTK_COMBO_BOX(COMBO))!=NULL)   /* on vérifie qu'il existe                                       */
   gtk_combo_box_remove_text(GTK_COMBO_BOX(COMBO),0);              /* il existe : on l'enlève                                       */
  else
   i=0;                                                            /* on active la sortie de la boucle, si le combo est VIDE        */
 } while (i);
 
 /**********************************************/
 /* combo box : mise en place des item du menu */
 /**********************************************/
 for (i=1;i<=10;i++)                                                /* Je remplis la liste                                          */
 {
  gtk_combo_box_append_text(GTK_COMBO_BOX(COMBO),ch=g_strdup_printf("%d",i%10));
  free(ch);
 }
 gtk_combo_box_set_active(GTK_COMBO_BOX(COMBO),0);                 /* Je active le premier élément                                  */
 
 code(chaine,chaine_cherchee);
 
 sprintf(aff_chaine,"<span font_family=\"Courier New\">%s</span>",chaine); /*dernière manipulation sur la chaine avant de l'afficher*/
 gtk_label_set_markup(GTK_LABEL(AFF_OPERATION),aff_chaine);         /* on impose un style courrier pour l'alignement                */
 
 sprintf(aff_chaine,"\n%hu partie%c gagnée%c",partie,partie>1?'s':' ',partie>1?'s':' ');
 gtk_label_set_text(GTK_LABEL(AFF_PARTIE),aff_chaine);              /* affichage du numéro de la partie jouée                       */
}

void nv_nombres(GtkWidget * a, gpointer * donnees)                  /* avant de changer l'opération on signale au FICHIER de trace  */
{                                                                   /* que c'est une nouvelle partie                                */
 fprintf(FICHIER,"</partie>\n<partie>\n");
 nouv_nombres(donnees);                                             /* puis on change les nombres                                   */
 (void)a;
}

