/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : dim jui  6 13:54:23 CEST 2003
    copyright            : (C) 2003 by Troumad
    email                : troumad@libertysurf.fr
    web			 :  http://troumad.free.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <klocale.h>

#include <kfiledialog.h>

#include <stdio.h>

#include <qfiledialog.h>

#include "mon_essai.h"

static const char *description =
	I18N_NOOP("Mon_essai");
// INSERT A DESCRIPTION FOR YOUR APPLICATION HERE

char ** xf_e_aff;
char ** xf_s_aff;
sub_ecran * mode;
int li;

char acces[200];
item_xf en_xf[10];

int lignes(FILE * fichier)
{
 char c;
 int ligne=0;

 while (fscanf(fichier,"%c",&c)!=EOF)
 {
  if (c==10) ligne++;
 }
 return ligne;
}

static KCmdLineOptions options[] =
{
  { 0, 0, 0 }
  // INSERT YOUR COMMANDLINE OPTIONS HERE
};

int main(int argc, char *argv[])
{
 FILE * xf_entree=NULL;

 QIconViewItem * voisin;
 QIconViewItem * lui;
 item_xf * courant;
 s_sc * ecran;
 s_m * moniteur;
 s_e * ce;


 QString Qs;
 char ligne[100];
 char * s;
 int l=0;
 int c=0;
 int i,j,k,x,y,x0,y0;
 int drapeau;
 int ou=-1;
 int rang[100][4]; // comme mode de sub_ecran + 2 entres taille et place

 nb_couleur[0]=puis2(8);
 nb_couleur[1]=puis2(15);
 nb_couleur[2]=puis2(16);
 nb_couleur[3]=puis2(24);
 nb_couleur[4]=puis2(30);

 KAboutData aboutData( "mon_essai", I18N_NOOP("Mon_essai"),
    VERSION, description, KAboutData::License_GPL,
    "(c) 2003, Troumad", 0, 0, "troumad@libertysurf.fr");
 aboutData.addAuthor("Troumad",0, "troumad@libertysurf.fr");
 KCmdLineArgs::init( argc, argv, &aboutData );
 KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

 KApplication a; // on ne peut dfinir qu'une seule KApplication
 //QApplication a( argc, argv );
 do
 {
  strcpy(acces,"/etc/X11/XF86Config-4");

  QFileDialog * d_chemin = new QFileDialog();
  a.setMainWidget(d_chemin);// dfinition de la premire KApplication
  Qs = d_chemin->getOpenFileName( acces,QString::null,0,0,QString::null,0,TRUE);
                            // affichage et excution de la premire KApplication
  if (Qs.isEmpty())         // Si on a appuy sur 'Cancel' ou la croix en haut  droite
  {
   alerte("Fin","<p>Vous venez d'annuler.<br>Le programme s'arrte donc.</p><p><br></p><p align='right'>http://troumad.free.fr</p>");
   return 0;               // Fin du programme
  }
  else
  {
   strcpy(acces,Qs);        // J'ai besoin d'une chane de caractre, pas d'une QString que je ne sais pas encore utiliser..
   if (acces!=NULL) xf_entree=fopen(acces,"r");
  }
 } while (xf_entree==NULL); // Tant que je n'ai pas un fichier lisible

 Mon_essai *mon_essai = new Mon_essai();
 a.setMainWidget(mon_essai);

 strcpy(ch_xinerama,"<br><font color='#FF0000'>Xinerama : mme nombre de couleurs pour tous les crans.</font>");

 for (i=0;i<10;i++)
  en_xf[i].info=NULL;

 li=lignes( xf_entree);
 xf_e_aff=(char **)calloc((li+1),sizeof(char*));
 xf_s_aff=(char **)calloc((li+1),sizeof(char*));
 fclose(xf_entree);

 xf_entree=fopen(acces,"r");
 do
 {
  xf_e_aff[l]=(char *)malloc(200);

  fgets(ligne,99,xf_entree);

  xf_s_aff[l]=(char *)malloc(200);
  strcpy(xf_s_aff[l],ligne);

  i=0;
  while (ligne[i]!=10 && ligne[i]==' ')
  {
   i++;
  }
  //printf("%d=>%s\n",i,ligne+i);
  if (strncmp(ligne+i,"Section",7)==0) // trouve les grandes sections de XF86Config-4
  {
   if (strncmp(ligne+i+9,"Files",5)==0)
   {
    ou=files;         // ou indique le nom de la dernire section trouve
    courant=en_xf+ou; // courant pointe sur les infos de la dernire section trouve
    courant->ligne=l; // on retient la premire ligne de la section
   }
   else
   if (strncmp(ligne+i+9,"ServerFlags",10)==0)
   {
    ou=serverflags;
    courant=en_xf+ou;
    courant->ligne=l;
   }
   else
   if (strncmp(ligne+i+9,"Module",6)==0)
   {
    ou=module;
    courant=en_xf+ou;
    courant->ligne=l;
   }
   else
   if (strncmp(ligne+i+9,"InputDevice",11)==0)
   {
    ou=inputdevice;
    courant=en_xf+ou;
    courant->ligne=l;
   }
   else
   if (strncmp(ligne+i+9,"Monitor",7)==0)
   {
    ou=monitor;
    courant=en_xf+ou;
    courant->ligne=l;
    if (courant->info!=NULL)
    {
     moniteur=(s_m *)(courant->info);
     while (moniteur->suiv!=NULL)
     {
      moniteur=moniteur->suiv;
     }
     moniteur->suiv=(s_m *)malloc(sizeof(s_m));
     moniteur=moniteur->suiv;
    }
    else
    {
     courant->info=(s_m *)malloc(sizeof(s_m));
     moniteur=(s_m *)(courant->info);
    }
    moniteur->suiv=NULL;
    moniteur->ligne=l;

    moniteur->vendeur[0]=0;
    moniteur->hori[0]=0;
    moniteur->vert[0]=0;
   }
   else
   if (strncmp(ligne+i+9,"Device",6)==0)
   {
    ou=device;
    courant=en_xf+ou;
    courant->ligne=l;

    if (courant->info!=NULL)
    {
     ce=(s_e *)(courant->info);
     while (ce->suiv!=NULL)
     {
      ce=ce->suiv;
     }
     ce->suiv=(s_e *)malloc(sizeof(s_e));
     ce=ce->suiv;
    }

    else
    {
     courant->info=(s_e *)malloc(sizeof(s_e));
     ce=(s_e *)(courant->info);
    }
    ce->suiv=NULL;
    ce->ligne=l;
    ce->identifier[0]=0;
    ce->vendeur[0]=0;
    ce->nom[0]=0;
    ce->place[0]=0;
    ce->pilote[0]=0;
    ce->ram=0;
   }
   else
   if (strncmp(ligne+i+9,"Screen",6)==0)
   {
    nbecran++;
    ou=screen;
    courant=en_xf+ou;
    courant->ligne=l;
    if (courant->info!=NULL)
    {
     ecran=(s_sc *)(courant->info);
     while (ecran->suiv!=NULL)
     {
      ecran=ecran->suiv;
     }
     ecran->suiv=(s_sc *)malloc(sizeof(s_sc));
     ecran->suiv->prec=ecran;
     ecran=ecran->suiv;
    }
    else
    {
     courant->info=(s_sc *)malloc(sizeof(s_sc));
     ecran=(s_sc *)(courant->info);
     ecran->prec=NULL;
    }
    ecran->suiv=NULL;
    ecran->ligne=l;
    ecran->mode=NULL;
    mode=NULL;
    ecran->modeline=NULL;
    ecran->nb_mode=0;
    ecran->HSP=1;
    ecran->HBT=3;
    ecran->VSP=500;
    ecran->bp_max=200;
    ecran->bp_min=30;
    ecran->largeur_max=0;
    ecran->largeur_min=0;
    ecran->mode_perso=FALSE;
    ecran->garde_mode=TRUE;
    ecran->num_mode=0;
   }
   else
   if (strncmp(ligne+i+9,"ServerLayout",12)==0)
   {
    ou=serverlayout;
    courant=en_xf+ou;
    courant->info=(s_l *)malloc(sizeof(s_l));
    ((s_l *)(courant->info))->clavier[0]=0;
    ((s_l *)(courant->info))->souris[0]=0;
    for(j=0;j<4;j++)
     for (k=0;k<3;k++)
      ((s_l *)(courant->info))->ecran[j][k][0]=0;
    ((s_l *)(courant->info))->xinerama=0;
    courant->ligne=l;
    ((s_l *)(courant->info))->xinerama=0;
   }
   else
    printf("%s\n",ligne+i+9);

   drapeau=22;
   strcpy(xf_e_aff[l],"<font color='#ff0000'>");
  }
  else
  if (ligne[i]=='#')
  {
   drapeau=22;
   strcpy(xf_e_aff[l],"<font color='#666666'>");
  }
  else
  if (strncmp(ligne+i,"Identifier",10)==0)
  {
   drapeau=22;
   strcpy(xf_e_aff[l],"<font color='#008800'>");
   for (j=0;ligne[j+i+12]!='"' && ligne[j+i+12]!=0;j++)
    courant->identifier[j]=ligne[i+j+12];
   if (ou==screen)
   {
    strcpy(ecran->identifier,courant->identifier);
   }
   else if (ou==monitor)
   {
    strcpy(moniteur->identifier,courant->identifier);
   }
   else if (ou==device)
   {
    strcpy(ce->identifier,courant->identifier);
   }
  }
  else
  {
   switch(ou)
   {
    case serverlayout :
	if (strncmp(ligne+i,"InputDevice",11)==0)
	{
	 j=i+13;
	 while (ligne[j]!='"' && ligne[j]!=10)
	 j++;
	 if (strncmp(ligne+j+3,"CoreKeyboard",12)==0) //!!Il faut avant trouver le nom!
	 {
	  strncpy(((s_l *)(courant->info))->clavier,ligne+i+13,j-i-13);
	 }
	 else
	 if (strncmp(ligne+j+3,"CorePointer",11)==0) //!!Il faut avant trouver le nom!
	 {
	  strncpy(((s_l *)(courant->info))->souris,ligne+i+13,j-i-13);
	 }
	}
	if (strncmp(ligne+i,"Screen",6)==0)
	{
	 j=0;
	 while (((s_l *)(courant->info))->ecran[j][0][0]!=0 && j<4)
	  j++;
	 if (j>=4) printf("Trop d'crans!!!!\n");
	 ((s_l *)(courant->info))->ligne[j]=l;
	 k=0;
	 while (ligne[k+i+8]!='"' && ligne[k+i+8]!=10)
	 {
	  ((s_l *)(courant->info))->ecran[j][0][k]=ligne[k+i+8];
	  k++;
	 }
	 ((s_l *)(courant->info))->ecran[j][0][k]=0;
	 k++;
	  while (ligne[k+i+8]==' ' && ligne[k+i+8]!=10)
	   k++;
	 if (ligne[k+i+8]!=10) // Juste pour vit le cas qui n'a pas de rfrence (comme si c'tait Absolute 0 0)
	 {
	  while (ligne[k+i+8]==' ' && ligne[k+i+8]!=10)
	   k++;
	  if (ligne[k+i+8]=='R')
	  {
	   if (ligne[k+i+9]=='i')
	   {
	    strcpy(((s_l *)(courant->info))->ecran[j][1],"RightOf");
	   }
	   else
	   {
	    strcpy(((s_l *)(courant->info))->ecran[j][1],"Relative ");
	   }
	  }
	  else
	  if (ligne[k+i+8]=='L')
	  strcpy(((s_l *)(courant->info))->ecran[j][1],"LeftOf");
	  else
	  if (ligne[k+i+8]=='A')
	   if (ligne[k+i+10]=='o')
	    strcpy(((s_l *)(courant->info))->ecran[j][1],"Above");
	   else
	   {
	    strcpy(((s_l *)(courant->info))->ecran[j][1],"Absolute ");
	    i+=9;
	   }
	  else
	  if (ligne[k+i+8]=='B')
	   strcpy(((s_l *)(courant->info))->ecran[j][1],"Below");
          i+=k+8;
	  if (((s_l *)(courant->info))->ecran[j][1][4]!='l' && ((s_l *)(courant->info))->ecran[j][1][0]!=0)
	  {
	   while (ligne[i]!='"' && ligne[i]!=10)
	   {
	    i++;
	   }
	   i++;
	   k=0;
	   while (ligne[k+i]!='"' && ligne[k+i]!=10)
	   {
	    ((s_l *)(courant->info))->ecran[j][2][k]=ligne[i];
	    k++;i++;
	   }
	   ((s_l *)(courant->info))->ecran[j][2][k]=0;
	   k++;
	  }
	  if (((s_l *)(courant->info))->ecran[j][1][7]=='e') // Absolute et Relative
	  {
	   sscanf(ligne+i,"%d %d",&x,&y);
	   sprintf(((s_l *)(courant->info))->ecran[j][1]+9,"%d %d",x,y);
	  }
	 }
	}
	if (strncmp(ligne+i,"Option",6)==0)
	{
	 i+=6;
	 while (ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 if (strncmp("Xinerama",ligne+i,8)==0)
	 {
	  i+=9;
	  while (ligne[i]!='"' && ligne[i]!=10) i++;
	  i++;
	  if (strncmp("Off",ligne+i,8)==0)
	  {
           ((s_l *)(courant->info))->xinerama=FALSE;
	  }
	  else
	  {
           ((s_l *)(courant->info))->xinerama=TRUE;
	  }
	 }
	}
	break;
    case screen :
	if (strncmp(ligne+i,"Device",6)==0)
	{
	 i+=6;
	 while(ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 j=0;
	 while(ligne[i+j]!='"' && ligne[i]!=10)
	 {
	  ecran->c_e[j]=ligne[i+j];
	  j++;
	 }
	 ecran->c_e[j]=0;
	}
	if (strncmp(ligne+i,"Monitor",7)==0)
	{
	 i+=7;
	 while(ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 j=0;
	 while(ligne[i+j]!='"' && ligne[i+j]!=10)
	 {
	  ecran->moniteur[j]=ligne[i+j];
	  j++;
	 }
	 ecran->moniteur[j]=0;
	}
	if (strncmp(ligne+i,"DefaultColorDepth",17)==0)
	{
	 i+=17;
	 sscanf(ligne+i,"%d",&(ecran->couleurs));
	}
	if (strncmp(ligne+i,"Subsection",10)==0)
	{
	 i+=10;
	 while(ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 if (strncmp(ligne+i,"Display",7)==0)
	 {
          if (mode==NULL)
	  {
	   ecran->mode=(sub_ecran *)malloc(sizeof(sub_ecran));
	   mode=ecran->mode;
	   mode->suiv=NULL;
	  }
	  else
	  {
	   mode->suiv=(sub_ecran *)malloc(sizeof(sub_ecran));
	   mode=mode->suiv;
	   mode->suiv=NULL;
	  }
	  for (j=0;j<16;j++)
	   mode->mode[j][0]=0;
	 }
	}
	if (strncmp(ligne+i,"Depth",5)==0)
	{
	 i+=5;
         if (mode==NULL)
	 {
	  printf("Erreur quelque part!!! : Depth sans Subsection");
	 }
	 else
	 {
	  sscanf(ligne+i,"%d",&(mode->couleurs));
	 }
	}
	if (strncmp(ligne+i,"Modes",5)==0)
	{
	 i+=5;
         if (mode==NULL)
	 {
	  printf("Erreur quelque part!!! : Modes sans Subsection");
	 }
	 else
	 {
	  j=0;
	  mode->ligne=l;
	  do
	  {
	   while(ligne[i]!='"' && ligne[i]!=10) i++;
	   if (ligne[i]=='"')
	   {
	    i++;
	    sscanf(ligne+i,"%dx%d",rang[j],rang[j]+1);
	    rang[j][2]=rang[j][0]*rang[j][1];
	    rang[j][3]=0;
	   }
	   j++;
	   while(ligne[i]!='"' && ligne[i]!=10) i++;
	   if (ligne[i]=='"')
	   {
	    i++;
	   }
	  } while (ligne[i]!=10);
          rang[j][0]=0;
	  mode->mode[j][0]=0;
	  for (j=0;rang[j][0]!=0;j++) // rangement des tailles dans l'ordre!
	  {
           for (k=0;rang[k][0]!=0;k++)
	    if (k!=j && rang[k][2]>rang[j][2]) rang[j][3]++;
	  }
	  for (j=0;rang[j][0]!=0;j++)
	  {
           mode->mode[rang[j][3]][0]=rang[j][0];
           mode->mode[rang[j][3]][1]=rang[j][1];
	  }
	  if (ecran->couleurs==mode->couleurs) ecran->num_mode=rang[0][3];
	 }
	}
	break;
    case monitor :
	if (strncmp(ligne+i,"VendorName",10)==0)
	{
	 i+=10;
	 j=0;
	 while (ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 while (ligne[i+j]!='"' && ligne[i+j]!=10)
	 {
	  moniteur->vendeur[j]=ligne[j+i];
	  j++;
	 }
	 moniteur->vendeur[j]=0;
	}
	if (strncmp(ligne+i,"HorizSync",9)==0)
	{
	 i+=9;
	 while(ligne[i]==' ' && ligne[i]!=10) i++;
	 strcpy(moniteur->hori,ligne+i);
	}
	if (strncmp(ligne+i,"VertRefresh",11)==0)
	{
	 i+=11;
	 while(ligne[i]==' ' && ligne[i]!=10) i++;
	 strcpy(moniteur->vert,ligne+i);
	}
	break;
    case device :
	if (strncmp(ligne+i,"VendorName",10)==0)
	{
	 i+=10;
	 j=0;
	 while (ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 while (ligne[i+j]!='"' && ligne[i+j]!=10)
	 {
	  ce->vendeur[j]=ligne[j+i];
	  j++;
	 }
	 ce->vendeur[j]=0;
	}
	if (strncmp(ligne+i,"BoardName",9)==0)
	{
	 i+=9;
	 j=0;
	 while (ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 while (ligne[i+j]!='"' && ligne[i+j]!=10)
	 {
	  ce->nom[j]=ligne[j+i];
	  j++;
	 }
	 ce->nom[j]=0;
	}
	if (strncmp(ligne+i,"Driver",6)==0)
	{
	 i+=6;
	 j=0;
	 while (ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 while (ligne[i+j]!='"' && ligne[i+j]!=10)
	 {
	  ce->pilote[j]=ligne[j+i];
	  j++;
	 }
	 ce->pilote[j]=0;
	}
	if (strncmp(ligne+i,"BusID",5)==0)
	{
	 i+=5;
	 j=0;
	 while (ligne[i]!='"' && ligne[i]!=10) i++;
	 i++;
	 while (ligne[i+j]!='"' && ligne[i+j]!=10)
	 {
	  ce->place[j]=ligne[j+i];
	  j++;
	 }
	 ce->place[j]=0;
	}
	if (strncmp(ligne+i,"VideoRam",8)==0)
	{
	 i+=8;
	 sscanf(ligne+i,"%d",&(ce->ram));
	}
	break;
   }
   drapeau=0;
  }
  strcpy(xf_e_aff[l]+drapeau,ligne);
  i=0;
  while (xf_e_aff[l][i]!=10)
  {
   c++;i++;
  }
  c+=5;
  if (drapeau)
  {
   strcpy(xf_e_aff[l]+i,"</font>");
   i+=6;
   c+=6;
  }
  xf_e_aff[l][i]='<';xf_e_aff[l][i+1]='b';xf_e_aff[l][i+2]='r';xf_e_aff[l][i+3]='>';xf_e_aff[l][i+4]=0;
  realloc(xf_e_aff[l],i+5);
  l++;
 }
 while (l<li);
 fclose(xf_entree); // fin de la lecture des donnes et de la fabrication de la base de donnes

 s=(char *)malloc(c);
 c=0;
 for (i=0;i<li;i++) // affichage de XF86Config-4 dans la fentre adquate
 {
  j=0;
  while(xf_e_aff[i][j]!=0)
  {
   s[c]=xf_e_aff[i][j];
   j++;
   c++;
  }
 }
 mon_essai->xf86->setText(s);

 ecran=(s_sc *)(en_xf[screen].info);
 i=0; // dessine les crans
 for (j=0;j<nbecran;j++)   // attention l'ordre des crans n'est pas obligatoirement le mme que celui d'apparition dans le serveurlayout!
 {
  ecran=ecran_n(j);
  mode=ecran->mode;
  while (ecran->couleurs!=mode->couleurs && mode->suiv!=NULL) mode=mode->suiv;
  i++;
  (void) new QIconViewItem( mon_essai->iconView1 , tr2i18n( ligne ), dessine_ecran(i,mode->mode[ecran->num_mode][0]/ECHELLE,mode->mode[ecran->num_mode][1]/ECHELLE,mode->mode[0][0]/ECHELLE,mode->mode[0][1]/ECHELLE,mon_essai));
 }

 mon_essai->show();

 mon_essai->decalage->setChecked(FALSE);
 lui=mon_essai->iconView1->firstItem(); // place les crans
 lui->move(lui->x()+150,lui->y()+130); // le premier cran au milieu

 for (j=0;j<nbecran;j++,lui=lui->nextItem()) // parcours des crans
 {
  if (((s_l *)(en_xf[serverlayout].info))->ecran[j][1][0]!=0) // viter le cas nul, seule possibilit : premier cran
  {
   if (((s_l *)(en_xf[serverlayout].info))->ecran[j][2][0]!=0) // sinon, c'est qu'on est en Absolut
   {// recherche du voisin
    voisin=mon_essai->iconView1->firstItem();
    i=0;
    ecran=(s_sc *)(en_xf[screen].info);
    while (strcmp(((s_l *)(en_xf[serverlayout].info))->ecran[j][2],ecran->identifier)!=0 && ecran->suiv!=NULL && i<nbecran)
    {
     ecran=ecran->suiv;
     i++;
     voisin=voisin->nextItem();
    }
    if (((s_l *)(en_xf[serverlayout].info))->ecran[j][1][0]=='R')
    {
     if (((s_l *)(en_xf[serverlayout].info))->ecran[j][1][1]=='i')
     {
       lui->move(voisin->x()+hauteur(voisin,mon_essai),voisin->y()); // RightOf
     }
     else
     {
      sscanf(((s_l *)(courant->info))->ecran[j][1]+9,"%d %d",&x,&y);
      lui->move(voisin->x()+x/ECHELLE,voisin->y()+y/ECHELLE); // Relative
     }
    }
    else
    if (((s_l *)(en_xf[serverlayout].info))->ecran[j][1][0]=='L') // LeftOf
    {
     lui->move(voisin->x()-hauteur(lui,mon_essai),voisin->y());
    }
    else
    if (((s_l *)(en_xf[serverlayout].info))->ecran[j][1][0]=='A') // Above
    {
     lui->move(voisin->x(),voisin->y()-largeur(voisin,mon_essai));
    }
    else //Below
    {
     lui->move(voisin->x(),voisin->y()+largeur(lui,mon_essai));
    }
   }
   else // Absolute
   {
    sscanf(((s_l *)(courant->info))->ecran[j][1]+9,"%d %d",&x,&y);
    if (j==0) // on dfini x0 et y0
    {
     x0=lui->x()*ECHELLE-x;
     y0=lui->y()*ECHELLE+y;
    }
    else
    {
     lui->move((x0+x)/ECHELLE,(y0-y)/ECHELLE);
    }
   }
  }
  else
  {
   x0=lui->x()*ECHELLE;
   y0=lui->y()*ECHELLE;
  }
 }

 mon_essai->choisi_taille->setValue(((s_sc *)(en_xf[screen].info))->num_mode);
 switch (((s_sc *)(en_xf[screen].info))->couleurs)
 {
  case  8 : mon_essai->choisi_profondeur->setCurrentItem(0);break;
  case 15 : mon_essai->choisi_profondeur->setCurrentItem(1);break;
  case 16 : mon_essai->choisi_profondeur->setCurrentItem(2);break;
  case 24 : mon_essai->choisi_profondeur->setCurrentItem(3);break;
  case 30 : mon_essai->choisi_profondeur->setCurrentItem(4);break;
 }
 mon_essai->iconView1->setCurrentItem(mon_essai->iconView1->firstItem());
 mon_essai->xinerama->setChecked(((s_l *)(en_xf[serverlayout].info))->xinerama);
 mon_essai->mem_mode->setChecked(TRUE);
 afficheicone(mon_essai->choisi_taille->value(),mon_essai);

 return a.exec();
}
