/***************************************************************************
                          mon_essai.h  -  description
                             -------------------
    begin                : dim jui  6 13:54:23 CEST 2003
    copyright            : (C) 2003 by Troumad
    email                : troumad@libertysurf.fr
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef MON_ESSAI_H
#define MON_ESSAI_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "le_mien.h"
#include <qwidget.h>
#include <qlabel.h>
#include <qiconview.h>
#include <qcheckbox.h>
#include <qtextbrowser.h>
#include <qslider.h>
#include <qcombobox.h>
#include <qradiobutton.h>
#include <qlineedit.h>
#include <qpixmap.h>
#include <qtabwidget.h>
#include <qpainter.h>
#include <qbitmap.h>
#include <qpushbutton.h>

#include <kapp.h>
#include <qwidget.h>

#define files 0
#define serverflags 1
#define module 2
#define inputdevice 3
#define monitor 4
#define device 5
#define screen 6
#define display 7
#define serverlayout 9
#define ECHELLE 20 // rapport d'affichage de taille des crans

#include <string.h>

// structure de donnes fates  partir du fichier de configuration

/** Mon_essai is the base class of the project */

/*class Demande_chemin : public demande_chemin
{
  Q_OBJECT
  public:
    // construtor
    Demande_chemin(QWidget* parent=0, const char *name=0);
    // destructor
    ~Demande_chemin();

public slots:
    virtual void nouveau_chemin();

};*/


class Mon_essai : public le_mien
{
  Q_OBJECT
  public:
    /** construtor */
    Mon_essai(QWidget* parent=0, const char *name=0);
    /** destructor */
    ~Mon_essai();

public slots:
    virtual void placeecran();
    virtual void affichetaille( int );
    virtual void afficheecran( QIconViewItem * );
    virtual void affichememoire();
    virtual void sauvegarde();
    virtual void affichenbcouleur(int);
    virtual void changemodefreq();
    virtual void changemodeori();
    virtual void validexinerama(int);
    virtual void calculemodeecran();
    virtual void gardemode();
};

struct item_xf // Pour chaque nom de sections
{
 char identifier[20];
 void * info; // adapt pour chaque section
 int ligne;
};

extern item_xf en_xf[10]; // un item par entre diffrente que je connais

struct s_l // Adaptation pour la section serverlayout
{
 char clavier[20];
 char souris[20];
 char ecran[4][3][20]; // 4 est le nombre max d'cran gr
 int ligne[4];
 bool xinerama;
};

struct sub_ecran // sous section modes de screen inutile?
{
 int couleurs;
 int mode[100][2]; // quand je le gnre, il peut tre vraiment grand!
 int ligne;
 sub_ecran * suiv;
};

struct s_sc // Adaptation pour la section screen
{
 char identifier[20];
 char c_e[20];
 char moniteur[20];
 int couleurs;
 bool mode_perso;
 bool garde_mode;
 char * modeline;
 int num_mode; // numro du mode choisi
 int bp_max;
 int bp_min;
 int HSP;
 int HBT;
 int VSP;
 int largeur_max;
 int largeur_min;
 int nb_mode;
 int ligne;
 s_sc * suiv;
 s_sc * prec;
 sub_ecran * mode;
};

struct s_m // Adaptation pour la section monitor
{
 char identifier[20];
 int ligne;
 char vendeur[20];
 char hori[8];
 char vert[8];
 s_m * suiv;
};

struct s_e // Adaptation pour la carte cran (section device)
{
 char identifier[20];
 int ligne;
 char vendeur[20];
 char nom[20];
 char place[15];
 char pilote[20];
 int ram;
 s_e * suiv;
};


// main.cpp
extern char ** xf_e_aff;
extern char ** xf_s_aff;
extern int li;
extern char acces[200];

// mon_essai.cpp
extern int nb_couleur[5];
extern char ch_xinerama[100];
extern int nbecran;
extern QIconViewItem * selection;

// routine.cpp
s_sc * ecran_n(int);
QPixmap dessine_ecran(int,int,int,int,int, Mon_essai *);
int hauteur(QIconViewItem *, Mon_essai *);
int eccart_x(QIconViewItem *,QIconViewItem *, Mon_essai *);
int largeur(QIconViewItem *, Mon_essai *);
int eccart_y(QIconViewItem *,QIconViewItem *, Mon_essai *);
int calcul_dist(QIconViewItem *,QIconViewItem *, Mon_essai *);
void ecran(QIconViewItem *, Mon_essai *);
void ajuste_mode_choisi( Mon_essai *);
void afficheicone(int, Mon_essai *);
void alerte(char *,char *);

// fichier math.cpp
int puis2(int n); // calcule 2^n
float max(float i, float j);
float min(float i, float j);
int car(int i); // calcule i*i=i^2
float puis2(float n); // calcule 2^n
int max(int i, int j);
int min(int i, int j);
float car(float i); // calcule i*i=i^2

#endif
