<?php

// defines if this script requires to be logged in
define( "PRIVATE", false );

# Call common libraries
require_once('./lib/inc-common.php');
require_once(FS_PATH."/etc/locale/".LANG_PACK."/inc-play.php");

ensure_defined_REQUEST('do');
ensure_defined_REQUEST('subs', 0);
ensure_defined_REQUEST('random', 0);
ensure_defined_REQUEST('id');
ensure_defined_REQUEST('count', 5);

########################################

# determine if #EXTINF should be included in the playlist
$extinfo = ( stristr(strtolower($_SERVER['HTTP_USER_AGENT']),"windows")
          && (!stristr(strtolower($_SERVER['HTTP_USER_AGENT']),"konqueror")));

# global variables which will be filled with playlist info
$pls_url = array();
$pls_info = array();
$pls_index = array();
$pls_count = 0;

########################################

if ( ($_REQUEST['do'] == "play") || ($_REQUEST['do'] == "plist") ) {

  m3uMe($_REQUEST['do'],$_REQUEST['val'],$_REQUEST['random']);

} elseif ($_REQUEST['do'] == "play_all") {

  m3uAll($_REQUEST['type'],$_REQUEST['id'],$_REQUEST['random'],$_REQUEST['subs']);

} elseif ($_REQUEST['do'] == "dispatch") {

  dispatchMe($_REQUEST['val']);

} elseif ($_REQUEST['do'] == "radio") {

  radioMe($_REQUEST['val']);

} elseif ($_REQUEST['do'] == "play_latest") {

  m3uLatest ($_REQUEST['type'], $_REQUEST['random'], $_REQUEST['count']);

} else {

   header ("Location: index.php\n\n");

   exit;

}

########################################

function expandLocation($location) {
    $location  = separatorCleanup($location);

    # Append streaming server value if location doesn't contain ://
    # Scanning for :// only because full protocol could be http://, https://, rtsp://, etc.
    # This enables to add internet radio stations or files streamed from multiple servers by
    # simply having a full url (eg: http://other.host.dom/path/to/media/file.mp3) in the
    # track's location field.
    if (!strstr($location,"://")) $location = STREAM_SRVR."/".$location;

    # Append web path value if location still doesn't contain ://
    # Copes with the fact that the streaming server could be a relative path (eg: music/)
    # instead of a protocol+hostname combination (http://streaming.host.dom)
    if (!strstr($location,"://")) $location  = WEB_PATH."/".$location;

    $location = separatorCleanup($location);

    return $location;
}

########################################

function playMe($tr_id) {

  GLOBAL $dbconn, $NETJUKE_SESSION_VARS;

  $dbrs = $dbconn->Execute("SELECT tr.location, tr.name, ar.name, al.name ".
    "from netjuke_tracks tr, netjuke_artists ar, netjuke_albums al ".
    "where tr.al_id=al.id AND tr.ar_id=ar.id AND tr.id = $tr_id");

  if (isset($dbrs) && !$dbrs->EOF) {

    $location = $dbrs->fields[0];
    $dbrs->Close();

    # record this this track has been played once
    $dbconn->Execute( "update netjuke_tracks set dl_cnt = dl_cnt + 1 where id = $tr_id");

    # experimental on the fly reencoding, remove comment to use it! 
    # reencodeOnTheFly(MUSIC_DIR."/".rawurldecode($location), $dbrs->fields[1], $dbrs->fields[2], $dbrs->fields[3]);

    # send the track to the user's player
    header ( "Location: ".expandLocation($location) );
  }

}

########################################

function addToPlaylistBySQL($sql, $random = 0) {
  global $dbconn, $extinfo, $pls_url, $pls_info, $pls_index, $pls_count, $NETJUKE_SESSION_VARS;

  $trans = get_html_translation_table (HTML_ENTITIES);
  $trans = array_flip ($trans);

  $dbrs = $dbconn->Execute($sql);

  while (isset($dbrs) && !$dbrs->EOF) {

    $tr_location  = expandLocation($dbrs->fields[0]);
    $tr_time      = floor($dbrs->fields[1]);
    $tr_name      = strtr(format_for_display($dbrs->fields[2]),$trans);
    $ar_name      = strtr(format_for_display($dbrs->fields[3]),$trans);
    $al_name      = strtr(format_for_display($dbrs->fields[4]),$trans);
    $tr_id        = strtr(format_for_display($dbrs->fields[5]),$trans);

    if ($extinfo) $pls_info[$pls_count] = "#EXTINF:$tr_time,$tr_name - $ar_name ($al_name)";

    if (PROTECT_MEDIA == 't') {

      # xmms-fix: xmms recognizes ogg-files by '.ogg'-extension
      $ext = strrchr($tr_location, '.');
      if ($ext != FALSE) $ext = "&ext=$ext";
      else $ext = "";

      $pls_url[$pls_count] = WEB_PATH."/play.php?do=dispatch&val=".
        obfuscate_apply($tr_id.";".$NETJUKE_SESSION_VARS['session_id']).$ext;

    } else {

      $pls_url[$pls_count] = $tr_location;
      // update the track's download count.
      // Is normally done accurately in the dispatcher, but it is now optional...
      $dbconn->Execute( "update netjuke_tracks set dl_cnt = dl_cnt + 1 where id = ".$tr_id." " );
    }

    if ($random == 1) $pls_index[$pls_count] = $pls_count;
    $pls_count++;

    $dbrs->MoveNext();
  }

  $dbrs->Close();
}


function outputPlaylist($random = 0) {
    global $extinfo, $pls_url, $pls_info, $pls_index, $pls_count;

    if ($random == 1) {
      srand ((float) microtime() * 1000000);
      shuffle ($pls_index);
    }

    #header ("Content-type: audio/x-mpegurl; Content-Disposition: inline; filename=netjuke-".substr(time(),-7).".m3u" );
    header ("Content-type: audio/x-mpegurl;");
    header ("Content-Disposition: attachment; filename=netjuke-".substr(time(),-7).".m3u" );
    #header ("Content-type: text/plain");

    if ($pls_count > 0) {

      if ($extinfo) echo "#EXTM3U\r\n";

      for( $i=0; $i<count($pls_url); $i++) {

        if ($random == 1) $fileindex = $pls_index[$i];
        else $fileindex = $i;

        if ($extinfo) echo $pls_info[$fileindex]."\r\n";

        echo $pls_url[$fileindex]."\r\n";
      }

    }	// if count > 0
}

########################################

function m3uMe($do,$val,$random) {

  GLOBAL $dbconn, $NETJUKE_SESSION_VARS;

  if ($val != '') {

    if ($do == "plist") $val = get_pl_tracks(abs($val));

    $id = split(",",$val);

    $trans = get_html_translation_table (HTML_ENTITIES);
    $trans = array_flip ($trans);

    $playlist = "";
    foreach ($id as $this_id) {

      $sql = " SELECT tr.location, tr.time, tr.name, ar.name, al.name, tr.id "
           . " from netjuke_tracks tr, netjuke_artists ar, netjuke_albums al "
           . " where tr.id = $this_id and ar.id = tr.ar_id and al.id = tr.al_id ";

      addToPlaylistBySQL($sql, $random);
    }
    outputPlaylist($random);
  }
  exit;

}

########################################

function m3uAll($type, $id, $random, $include_subs=0) {

  GLOBAL $dbconn, $NETJUKE_SESSION_VARS;

    $ids = split(",",$id);

    foreach ($ids as $this_id) {

      // Iterate over each id
      $sub_clause = '';

      // Before building the query, determine if this is a genre and handle special case of sub-genres
      if ($type == 'ge') {

        if ($include_subs == 1) {

          $sql = " SELECT id from netjuke_genres where parent_id = ".$this_id;
          $sub_rs = $dbconn->Execute ($sql);

          while (! $sub_rs->EOF) {

            $sub_clause .= " or tr.ge_id = ".$sub_rs->fields[0]." ";
            $sub_rs->MoveNext();

          }

          $sub_rs->Close();
        }
        $sub_clause .= ")";
      }

      $sql = " SELECT distinct tr.location, tr.time, tr.name, ar.name, al.name, tr.id  "
            . " from netjuke_tracks tr, netjuke_artists ar, netjuke_albums al "
            . " , netjuke_genres ge where ar.id = tr.ar_id and al.id = tr.al_id ";

      if (    ( ($type =='ar') || ($type =='al') || ($type =='ge') )
            && ( is_numeric($this_id) )  ) {

        if ($type == 'ge')
          $sql .= ' and ( tr.'.$type.'_id = '.$this_id.' ';
        else
          $sql .= ' and tr.'.$type.'_id = '.$this_id.' ';

      }

      $sql .= $sub_clause." order by al.name, tr.track_number, ar.name, tr.id ";

      addToPlaylistBySQL($sql, $random);
    }

    outputPlaylist($random);

    exit;

}

########################################

function dispatchMe($dispatchid) {

   GLOBAL $dbconn;

   list($track, $orig_session_id) = split(";", obfuscate_undo($dispatchid));

   $dbrs = $dbconn->Execute(" select session_id from netjuke_sessions where session_id = '$orig_session_id' ");

   if ($dbrs->RecordCount() != 1) exit;

   // The following browser checks are only as secure as the concept
   // of user agents itself... we should get a list of acceptable players'
   // user agents and check against this instead, but older versions of
   // itunes didn't have a user agent
   if (    ( $_SERVER['HTTP_USER_AGENT'] != "")
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"mozilla")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"netscape")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"msie")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"wget")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"curl")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"galeon")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"konqueror")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"omniweb")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"interarchy")) < 1)
        && ( (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"anarchie")) < 1) ) {

     if (REAL_ONLY == 'f') {

       playMe($track);

     } elseif ( (REAL_ONLY == 't') && (substr_count(strtolower($_SERVER['HTTP_USER_AGENT']),"realmedia") == 1) ) {

       playMe($track);

     } else {

       header ( "Location: ".WEB_PATH."/etc/locale/".LANG_PACK."/real-error.mp3" );

     }

   } else {

     exit;

   }

}

########################################

function radioMe() {

  header ("Content-type: audio/x-mpegurl;");
  header ("Content-Disposition: attachment; filename=netjuke-".substr(time(),-7).".m3u" );

  echo "#EXTM3U\r\n";
  echo RADIO_URL;

}

########################################

function m3uLatest ($type, $random, $count) {

  global $dbconn;

  if ($type == 'al')
    $table = 'netjuke_albums';
  else
    $table = 'netjuke_artists';

  $clause = '';
  $sql = " SELECT id "
      . " from " . $table . " "
      . " where track_cnt > 0 "
      . " order by id desc ";

  $dbrs = $dbconn->SelectLimit ($sql, $count);

  while (isset ($dbrs) && ! $dbrs->EOF) {
    if ($clause != '') $clause .= ' or ';
    $clause .= $type.'_id = '.$dbrs->fields[0];
    $dbrs->MoveNext ();
  }

  $dbrs->Close();

  // Now grab the tracks
  $sql = " SELECT tr.location, tr.time, tr.name, ar.name, al.name, tr.id   "
       . " from netjuke_tracks tr, netjuke_artists ar, netjuke_albums al "
       . " where ar.id = tr.ar_id and al.id = tr.al_id AND ( "
       . $clause
       . " ) order by tr.id desc ";

  addToPlaylistBySQL($sql, $random);
  outputPlaylist($random);

}

######################################

function reencodeOnTheFly($filename, $tr_name = "Track", $ar_name = "Artist", $al_name = "Album") {
 
  # experimental streaming with reencoding via lame or mpg123/oggenc. This is
  # based on code posted on netjuke-users in this thread: 
  # http://sourceforge.net/mailarchive/message.php?msg_id=4188795
  #
  # This function is meant as proof of concept and is not supposed to run on
  # every system. Make sure to alter the paths to lame/mpg123/oggenc
  # according to your system. Only mp3->mp3 conversion is supported at the
  # moment. 

  $shellmask = array('\\', ' ', '&', ')', '(', '\'');

  foreach ($shellmask as $maskchar) {
    $tr_name = addcslashes($tr_name, $maskchar);
    $ar_name = addcslashes($ar_name, $maskchar);
    $al_name = addcslashes($al_name, $maskchar);
    $filename = addcslashes($filename, $maskchar);
  }

  // -------------------- general settings ---------------------

  set_time_limit(1800); // maximum length of a song

  // ----------------- generate mp3 settings -------------------

  $bitrate = 64; // desired streaming bitrate
  $lame = "/usr/local/bin/lame";

  header("Content-type: audio/mp3");
  $cmd = "$lame --add-id3v2 --ta $ar_name --tl $al_name --tt $tr_name -b $bitrate -f --silent $filename - ";

  // ----------------- genrate ogg settings --------------------

  # ### currently not working here, maybe you have more luck ###
  #
  # header("Content-type: audio/x-ogg");
  # $oggenc = "/usr/bin/oggenc";
  # $mpg123 = "/usr/bin/mpg123";
  #
  # $cmd = "$mpg123 -w - -q $filename | $oggenc -q 0 -Q -";

  // ----------------------------------------------------------- 

  echo passthru($cmd);
  exit;
}

?>
